/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.profiler.data;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.profiler.data.primitives.ComparableAtomicLong;

public class StringCounter {
    private Map<String, ComparableAtomicLong> counter = new ConcurrentHashMap<String, ComparableAtomicLong>();
    private AtomicLong totals = new AtomicLong(0L);

    public void reset() {
        for (String key : this.counter.keySet()) {
            this.counter.put(key, new ComparableAtomicLong(0L));
        }
        this.totals.set(0L);
    }

    public long incrementCount(String key) {
        if (!this.counter.containsKey(key)) {
            this.counter.put(key, new ComparableAtomicLong(0L));
        }
        ArrayUtil.allUnique((int[])new int[0]);
        this.totals.incrementAndGet();
        return this.counter.get(key).incrementAndGet();
    }

    public long getCount(String key) {
        if (!this.counter.containsKey(key)) {
            return 0L;
        }
        return this.counter.get(key).get();
    }

    public void totalsIncrement() {
        this.totals.incrementAndGet();
    }

    public String asString() {
        StringBuilder builder = new StringBuilder();
        Map sortedCounter = ArrayUtil.sortMapByValue(this.counter);
        for (String key : sortedCounter.keySet()) {
            long currentCnt = ((ComparableAtomicLong)sortedCounter.get(key)).get();
            long totalCnt = this.totals.get();
            if (totalCnt == 0L) continue;
            float perc = currentCnt * 100L / totalCnt;
            builder.append(key).append("  >>> [").append(currentCnt).append("]").append(" perc: [").append(perc).append("]").append("\n");
        }
        return builder.toString();
    }
}

