/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class CropAndResize
extends DynamicCustomOp {
    protected Method method = Method.BILINEAR;
    protected double extrapolationValue = 0.0;

    public CropAndResize(@NonNull SameDiff sameDiff, @NonNull SDVariable image, @NonNull SDVariable cropBoxes, @NonNull SDVariable boxIndices, @NonNull SDVariable cropOutSize, @NonNull Method method, double extrapolationValue) {
        super(sameDiff, new SDVariable[]{image, cropBoxes, boxIndices, cropOutSize});
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        if (cropBoxes == null) {
            throw new NullPointerException("cropBoxes is marked non-null but is null");
        }
        if (boxIndices == null) {
            throw new NullPointerException("boxIndices is marked non-null but is null");
        }
        if (cropOutSize == null) {
            throw new NullPointerException("cropOutSize is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        this.method = method;
        this.extrapolationValue = extrapolationValue;
        this.addArgs();
    }

    public CropAndResize(@NonNull SameDiff sameDiff, SDVariable image, SDVariable cropBoxes, SDVariable boxIndices, SDVariable cropOutSize, double extrapolationValue) {
        this(sameDiff, image, cropBoxes, boxIndices, cropOutSize, null, extrapolationValue);
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
    }

    public CropAndResize(@NonNull INDArray image, @NonNull INDArray cropBoxes, @NonNull INDArray boxIndices, @NonNull INDArray cropOutSize, @NonNull Method method, double extrapolationValue, INDArray output) {
        super(new INDArray[]{image, cropBoxes, boxIndices, cropOutSize}, null);
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        if (cropBoxes == null) {
            throw new NullPointerException("cropBoxes is marked non-null but is null");
        }
        if (boxIndices == null) {
            throw new NullPointerException("boxIndices is marked non-null but is null");
        }
        if (cropOutSize == null) {
            throw new NullPointerException("cropOutSize is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        Preconditions.checkArgument((image.rank() == 4 ? 1 : 0) != 0, (String)"Input image must be rank 4 with shape [batch, height, width, channels], got %ndShape", (Object)image);
        Preconditions.checkArgument((cropBoxes.rank() == 2 && cropBoxes.size(1) == 4L ? 1 : 0) != 0, (String)"Crop boxes must be rank 4 with shape [num_boxes, 5], got %ndShape", (Object)cropBoxes);
        Preconditions.checkArgument((boxIndices.rank() == 1 && cropBoxes.size(0) == boxIndices.size(0) ? 1 : 0) != 0, (String)"Box indices must be rank 1 array with shape [num_boxes] (same as cropBoxes.size(0), got array with shape %ndShape", (Object)boxIndices);
        this.method = method;
        this.extrapolationValue = extrapolationValue;
        this.addArgs();
        this.outputArguments.add(output);
    }

    public CropAndResize(INDArray image, INDArray cropBoxes, INDArray boxIndices, INDArray cropOutSize, double extrapolationValue) {
        this(image, cropBoxes, boxIndices, cropOutSize, null, extrapolationValue, null);
    }

    @Override
    public String opName() {
        return "crop_and_resize";
    }

    @Override
    public String tensorflowName() {
        return "CropAndResize";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        String method = attributesForNode.get("method").getS().toStringUtf8();
        this.method = method.equalsIgnoreCase("nearest") ? Method.NEAREST : Method.BILINEAR;
        if (attributesForNode.containsKey("extrapolation_value")) {
            this.extrapolationValue = attributesForNode.get("extrapolation_value").getF();
        }
        this.addArgs();
    }

    protected void addArgs() {
        this.addIArgument(this.method == Method.BILINEAR ? 0 : 1);
        this.addTArgument(this.extrapolationValue);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> out = new ArrayList<SDVariable>();
        for (SDVariable v : this.args()) {
            out.add(this.sameDiff.zerosLike(v));
        }
        return out;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 4 ? 1 : 0) != 0, (String)"Expected 4 input datatypes for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(DataType.FLOAT);
    }

    public CropAndResize() {
    }

    public static enum Method {
        BILINEAR,
        NEAREST;

    }
}

