/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.recurrent.outputs;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.common.base.Preconditions;

public class GRUCellOutputs {
    private SDVariable r;
    private SDVariable u;
    private SDVariable c;
    private SDVariable h;

    public GRUCellOutputs(SDVariable[] outputs) {
        Preconditions.checkArgument((outputs.length == 4 ? 1 : 0) != 0, (String)"Must have 4 GRU cell outputs, got %s", (int)outputs.length);
        this.r = outputs[0];
        this.u = outputs[1];
        this.c = outputs[2];
        this.h = outputs[3];
    }

    public List<SDVariable> getAllOutputs() {
        return Arrays.asList(this.r, this.u, this.c, this.h);
    }

    public SDVariable getOutput() {
        return this.h;
    }

    public SDVariable getR() {
        return this.r;
    }

    public SDVariable getU() {
        return this.u;
    }

    public SDVariable getC() {
        return this.c;
    }

    public SDVariable getH() {
        return this.h;
    }
}

