/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.segment;

import java.util.ArrayList;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.transforms.segment.bp.UnsortedSegmentSqrtNBp;

public class UnsortedSegmentSqrtN
extends DynamicCustomOp {
    private int numSegments;

    public UnsortedSegmentSqrtN(SameDiff sameDiff, SDVariable data, SDVariable segmentIds, int numSegments) {
        super(null, sameDiff, new SDVariable[]{data, segmentIds}, false);
        this.numSegments = numSegments;
        this.addIArgument(numSegments);
    }

    public UnsortedSegmentSqrtN(INDArray data, INDArray segmentIds, int numSegments) {
        super(new INDArray[]{data, segmentIds}, null);
        this.numSegments = numSegments;
        this.addIArgument(numSegments);
    }

    @Override
    public String opName() {
        return "unsorted_segment_sqrt_n";
    }

    @Override
    public String tensorflowName() {
        return "UnsortedSegmentSqrtN";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradients) {
        return new UnsortedSegmentSqrtNBp(this.sameDiff, this.arg(0), this.arg(1), gradients.get(0), this.numSegments).outputs();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && (inputDataTypes.size() == 2 || inputDataTypes.size() == 3) ? 1 : 0) != 0, (String)"Expected exactly 2 input data types for %s, got %s", this.getClass(), inputDataTypes);
        ArrayList<DataType> out = new ArrayList<DataType>();
        for (int i = 0; i < this.numSegments; ++i) {
            out.add(inputDataTypes.get(0));
        }
        return out;
    }

    public UnsortedSegmentSqrtN() {
    }
}

