/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.lossfunctions.impl;

import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.shape.OneHot;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.lossfunctions.impl.LossMCXENT;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LossSparseMCXENT
extends LossMCXENT {
    private static final double DEFAULT_SOFTMAX_CLIPPING_EPSILON = 1.0E-10;

    public LossSparseMCXENT() {
        this(null);
    }

    public LossSparseMCXENT(INDArray weights) {
        this(1.0E-10, weights);
    }

    public LossSparseMCXENT(@JsonProperty(value="softmaxClipEps") double softmaxClipEps, @JsonProperty(value="weights") INDArray weights) {
        super(softmaxClipEps, weights);
    }

    protected INDArray sparseScoreArray(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        INDArray oneHotLabels = this.toOneHot(labels, preOutput);
        return super.scoreArray(oneHotLabels, preOutput, activationFn, mask);
    }

    @Override
    public double computeScore(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask, boolean average) {
        INDArray oneHotLabels = this.toOneHot(labels, preOutput);
        return super.computeScore(oneHotLabels, preOutput, activationFn, mask, average);
    }

    @Override
    public INDArray computeScoreArray(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        INDArray scoreArr = this.sparseScoreArray(labels, preOutput, activationFn, mask);
        return scoreArr.sum(true, 1).muli(-1);
    }

    @Override
    public INDArray computeGradient(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask) {
        INDArray oneHotLabels = this.toOneHot(labels, preOutput);
        return super.computeGradient(oneHotLabels, preOutput, activationFn, mask);
    }

    @Override
    public Pair<Double, INDArray> computeGradientAndScore(INDArray labels, INDArray preOutput, IActivation activationFn, INDArray mask, boolean average) {
        INDArray oneHotLabels = this.toOneHot(labels, preOutput);
        return new Pair((Object)super.computeScore(oneHotLabels, preOutput, activationFn, mask, average), (Object)super.computeGradient(oneHotLabels, preOutput, activationFn, mask));
    }

    private INDArray toOneHot(INDArray labels, INDArray preOutput) {
        Preconditions.checkState((labels.size(-1) == 1L ? 1 : 0) != 0, (String)"Labels for LossSparseMCXENT should be an array of integers with first dimension equal to minibatch size, and last dimension having size 1. Got labels array with shape %ndShape", (Object)labels);
        INDArray oneHotLabels = preOutput.ulike();
        Nd4j.exec(new OneHot(labels.reshape(labels.length()), oneHotLabels, (int)preOutput.size(-1)));
        return oneHotLabels;
    }

    @Override
    public String toString() {
        if (this.weights == null) {
            return "LossSparseMCXENT()";
        }
        return "LossSparseMCXENT(weights=" + this.weights + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LossSparseMCXENT)) {
            return false;
        }
        LossSparseMCXENT other = (LossSparseMCXENT)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LossSparseMCXENT;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

