/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.util;

import lombok.NonNull;

public class HashUtil {
    private static final long[] byteTable = HashUtil.createLookupTable();
    private static final long HSTART = -4953706369002393500L;
    private static final long HMULT = 7664345821815920749L;

    private static long[] createLookupTable() {
        long[] byteTable = new long[256];
        long h = 6074001001750140548L;
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 31; ++j) {
                h = h >>> 7 ^ h;
                h = h << 11 ^ h;
                h = h >>> 10 ^ h;
            }
            byteTable[i] = h;
        }
        return byteTable;
    }

    public static long getLongHash(@NonNull byte[] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        long h = -4953706369002393500L;
        long hmult = 7664345821815920749L;
        long[] ht = byteTable;
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            h = h * 7664345821815920749L ^ ht[data[i] & 0xFF];
        }
        return h;
    }

    public static long getLongHash(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        long h = -4953706369002393500L;
        long hmult = 7664345821815920749L;
        long[] ht = byteTable;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            h = h * 7664345821815920749L ^ ht[ch & 0xFF];
            h = h * 7664345821815920749L ^ ht[ch >>> 8 & 0xFF];
        }
        return h;
    }
}

