/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.nd4j.context.Nd4jContext;
import org.nd4j.linalg.io.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Nd4jBackend {
    private static final Logger log = LoggerFactory.getLogger(Nd4jBackend.class);
    public static final int BACKEND_PRIORITY_CPU;
    public static final int BACKEND_PRIORITY_GPU;
    @Deprecated
    public static final String DYNAMIC_LOAD_CLASSPATH = "ND4J_DYNAMIC_LOAD_CLASSPATH";
    @Deprecated
    public static final String DYNAMIC_LOAD_CLASSPATH_PROPERTY = "org.nd4j.backend.dynamicbackend";
    private static boolean triedDynamicLoad;

    public abstract boolean allowsOrder();

    public abstract int getPriority();

    public abstract boolean isAvailable();

    public abstract boolean canRun();

    public abstract Resource getConfigurationResource();

    public abstract Class getNDArrayClass();

    public static Nd4jBackend load() throws NoAvailableBackendException {
        String[] jarUris;
        ArrayList<Nd4jBackend> backends = new ArrayList<Nd4jBackend>(1);
        ServiceLoader<Nd4jBackend> loader = ServiceLoader.load(Nd4jBackend.class);
        try {
            Iterator<Nd4jBackend> backendIterator = loader.iterator();
            while (backendIterator.hasNext()) {
                backends.add(backendIterator.next());
            }
        }
        catch (ServiceConfigurationError serviceError) {
            throw new RuntimeException("failed to process available backends", serviceError);
        }
        Collections.sort(backends, new Comparator<Nd4jBackend>(){

            @Override
            public int compare(Nd4jBackend o1, Nd4jBackend o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
        for (Nd4jBackend backend : backends) {
            boolean available = false;
            String error = null;
            try {
                available = backend.isAvailable();
            }
            catch (Exception e) {
                error = e.getMessage();
            }
            if (!available) {
                log.warn("Skipped [{}] backend (unavailable): {}", (Object)backend.getClass().getSimpleName(), (Object)error);
                continue;
            }
            try {
                Nd4jContext.getInstance().updateProperties(backend.getConfigurationResource().getInputStream());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            log.info("Loaded [{}] backend", (Object)backend.getClass().getSimpleName());
            return backend;
        }
        if (System.getProperties().containsKey(DYNAMIC_LOAD_CLASSPATH_PROPERTY) && !triedDynamicLoad) {
            jarUris = System.getProperties().getProperty(DYNAMIC_LOAD_CLASSPATH_PROPERTY).split(";");
        } else if (System.getenv(DYNAMIC_LOAD_CLASSPATH) != null && !triedDynamicLoad) {
            jarUris = System.getenv(DYNAMIC_LOAD_CLASSPATH).split(";");
        } else {
            throw new NoAvailableBackendException("Please ensure that you have an nd4j backend on your classpath. Please see: http://nd4j.org/getstarted.html");
        }
        triedDynamicLoad = true;
        for (String uri : jarUris) {
            Nd4jBackend.loadLibrary(new File(uri));
        }
        return Nd4jBackend.load();
    }

    public static synchronized void loadLibrary(File jar) throws NoAvailableBackendException {
        try {
            URLClassLoader loader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            URL url = jar.toURI().toURL();
            for (URL it : Arrays.asList(loader.getURLs())) {
                if (!it.equals(url)) continue;
                return;
            }
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)loader, url);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | MalformedURLException e) {
            throw new NoAvailableBackendException(e);
        }
    }

    public Properties getProperties() throws IOException {
        return this.getContext().getConf();
    }

    public Nd4jContext getContext() throws IOException {
        return Nd4jContext.getInstance();
    }

    public String toString() {
        return this.getClass().getName();
    }

    static {
        triedDynamicLoad = false;
        int n = 0;
        String s = System.getenv("BACKEND_PRIORITY_CPU");
        if (s != null && s.length() > 0) {
            try {
                n = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(e);
            }
        }
        BACKEND_PRIORITY_CPU = n;
        n = 100;
        s = System.getenv("BACKEND_PRIORITY_GPU");
        if (s != null && s.length() > 0) {
            try {
                n = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(e);
            }
        }
        BACKEND_PRIORITY_GPU = n;
    }

    public static class NoAvailableBackendException
    extends Exception {
        public NoAvailableBackendException(String s) {
            super(s);
        }

        public NoAvailableBackendException(Throwable cause) {
            super(cause);
        }
    }
}

