/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.nativeblas;

import lombok.NonNull;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpaqueDataBuffer
extends Pointer {
    private static final Logger log = LoggerFactory.getLogger(OpaqueDataBuffer.class);
    private static final int MAX_TRIES = 5;

    public OpaqueDataBuffer(Pointer p) {
        super(p);
    }

    public static OpaqueDataBuffer externalizedDataBuffer(long numElements, @NonNull DataType dataType, Pointer primary, Pointer special) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        return NativeOpsHolder.getInstance().getDeviceNativeOps().dbCreateExternalDataBuffer(numElements, dataType.toInt(), primary, special);
    }

    public static OpaqueDataBuffer allocateDataBuffer(long numElements, @NonNull DataType dataType, boolean allocateBoth) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        OpaqueDataBuffer buffer = null;
        int ec = 0;
        String em = null;
        for (int t = 0; t < 5; ++t) {
            try {
                buffer = NativeOpsHolder.getInstance().getDeviceNativeOps().allocateDataBuffer(numElements, dataType.toInt(), allocateBoth);
                ec = NativeOpsHolder.getInstance().getDeviceNativeOps().lastErrorCode();
                if (ec == 0) {
                    return buffer;
                }
                em = NativeOpsHolder.getInstance().getDeviceNativeOps().lastErrorMessage();
                System.gc();
                Thread.sleep(50L);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Allocation failed: [" + em + "]");
    }

    public void expand(long numElements) {
        int ec = 0;
        String em = null;
        for (int t = 0; t < 5; ++t) {
            try {
                NativeOpsHolder.getInstance().getDeviceNativeOps().dbExpand(this, numElements);
                ec = NativeOpsHolder.getInstance().getDeviceNativeOps().lastErrorCode();
                if (ec == 0) {
                    return;
                }
                em = NativeOpsHolder.getInstance().getDeviceNativeOps().lastErrorMessage();
                System.gc();
                Thread.sleep(50L);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("DataBuffer expansion failed: [" + em + "]");
    }

    public OpaqueDataBuffer createView(long bytesLength, long bytesOffset) {
        OpaqueDataBuffer buffer = null;
        int ec = 0;
        String em = null;
        for (int t = 0; t < 5; ++t) {
            try {
                buffer = NativeOpsHolder.getInstance().getDeviceNativeOps().dbCreateView(this, bytesLength, bytesOffset);
                ec = NativeOpsHolder.getInstance().getDeviceNativeOps().lastErrorCode();
                if (ec == 0) {
                    return buffer;
                }
                em = NativeOpsHolder.getInstance().getDeviceNativeOps().lastErrorMessage();
                System.gc();
                Thread.sleep(50L);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("DataBuffer expansion failed: [" + em + "]");
    }

    public Pointer primaryBuffer() {
        return NativeOpsHolder.getInstance().getDeviceNativeOps().dbPrimaryBuffer(this);
    }

    public Pointer specialBuffer() {
        return NativeOpsHolder.getInstance().getDeviceNativeOps().dbSpecialBuffer(this);
    }

    public int deviceId() {
        return NativeOpsHolder.getInstance().getDeviceNativeOps().dbDeviceId(this);
    }

    public void setPrimaryBuffer(Pointer ptr, long numElements) {
        NativeOpsHolder.getInstance().getDeviceNativeOps().dbSetPrimaryBuffer(this, ptr, numElements);
    }

    public void setSpecialBuffer(Pointer ptr, long numElements) {
        NativeOpsHolder.getInstance().getDeviceNativeOps().dbSetSpecialBuffer(this, ptr, numElements);
    }

    public void syncToSpecial() {
        NativeOpsHolder.getInstance().getDeviceNativeOps().dbSyncToSpecial(this);
    }

    public void syncToPrimary() {
        NativeOpsHolder.getInstance().getDeviceNativeOps().dbSyncToPrimary(this);
    }

    public void closeBuffer() {
        NativeOpsHolder.getInstance().getDeviceNativeOps().dbClose(this);
    }
}

