/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.handlers.PullResponseCompletionListener;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.MetadataExtractor;

public class SessionPullResponseCompletionListener
implements PullResponseCompletionListener {
    private final BookmarkHolder bookmarkHolder;
    private final Connection connection;

    public SessionPullResponseCompletionListener(Connection connection, BookmarkHolder bookmarkHolder) {
        this.connection = Objects.requireNonNull(connection);
        this.bookmarkHolder = Objects.requireNonNull(bookmarkHolder);
    }

    @Override
    public void afterSuccess(Map<String, Value> metadata) {
        this.releaseConnection();
        this.bookmarkHolder.setBookmark(MetadataExtractor.extractBookmarks(metadata));
    }

    @Override
    public void afterFailure(Throwable error) {
        this.releaseConnection();
    }

    private void releaseConnection() {
        this.connection.release();
    }
}

