/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.security;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.util.CertificateTool;

public class SecurityPlanImpl
implements SecurityPlan {
    private final boolean requiresEncryption;
    private final SSLContext sslContext;
    private final boolean requiresHostnameVerification;

    public static SecurityPlan forAllCertificates(boolean requiresHostnameVerification) throws GeneralSecurityException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(new KeyManager[0], new TrustManager[]{new TrustAllTrustManager()}, null);
        return new SecurityPlanImpl(true, sslContext, requiresHostnameVerification);
    }

    public static SecurityPlan forCustomCASignedCertificates(File certFile, boolean requiresHostnameVerification) throws GeneralSecurityException, IOException {
        KeyStore trustedKeyStore = KeyStore.getInstance("JKS");
        trustedKeyStore.load(null, null);
        CertificateTool.loadX509Cert(certFile, trustedKeyStore);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(trustedKeyStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(new KeyManager[0], trustManagerFactory.getTrustManagers(), null);
        return new SecurityPlanImpl(true, sslContext, requiresHostnameVerification);
    }

    public static SecurityPlan forSystemCASignedCertificates(boolean requiresHostnameVerification) throws NoSuchAlgorithmException {
        return new SecurityPlanImpl(true, SSLContext.getDefault(), requiresHostnameVerification);
    }

    public static SecurityPlan insecure() {
        return new SecurityPlanImpl(false, null, false);
    }

    private SecurityPlanImpl(boolean requiresEncryption, SSLContext sslContext, boolean requiresHostnameVerification) {
        this.requiresEncryption = requiresEncryption;
        this.sslContext = sslContext;
        this.requiresHostnameVerification = requiresHostnameVerification;
    }

    @Override
    public boolean requiresEncryption() {
        return this.requiresEncryption;
    }

    @Override
    public SSLContext sslContext() {
        return this.sslContext;
    }

    @Override
    public boolean requiresHostnameVerification() {
        return this.requiresHostnameVerification;
    }

    private static class TrustAllTrustManager
    implements X509TrustManager {
        private TrustAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException("All client connections to this client are forbidden.");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

