/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Exceptions;
import org.neo4j.driver.internal.shaded.reactor.core.Fuseable;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.InnerOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.InternalMonoOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Mono;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.reactivestreams.Subscription;

final class MonoPeekTerminal<T>
extends InternalMonoOperator<T, T>
implements Fuseable {
    final BiConsumer<? super T, Throwable> onAfterTerminateCall;
    final Consumer<? super T> onSuccessCall;
    final Consumer<? super Throwable> onErrorCall;

    MonoPeekTerminal(Mono<? extends T> source, @Nullable Consumer<? super T> onSuccessCall, @Nullable Consumer<? super Throwable> onErrorCall, @Nullable BiConsumer<? super T, Throwable> onAfterTerminateCall) {
        super(source);
        this.onAfterTerminateCall = onAfterTerminateCall;
        this.onSuccessCall = onSuccessCall;
        this.onErrorCall = onErrorCall;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            return new MonoTerminalPeekSubscriber((Fuseable.ConditionalSubscriber)actual, this);
        }
        return new MonoTerminalPeekSubscriber<T>(actual, this);
    }

    static final class MonoTerminalPeekSubscriber<T>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T>,
    Fuseable.QueueSubscription<T> {
        final CoreSubscriber<? super T> actual;
        final Fuseable.ConditionalSubscriber<? super T> actualConditional;
        final MonoPeekTerminal<T> parent;
        Subscription s;
        @Nullable
        Fuseable.QueueSubscription<T> queueSubscription;
        int sourceMode;
        volatile boolean done;
        boolean valued;

        MonoTerminalPeekSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, MonoPeekTerminal<T> parent) {
            this.actualConditional = actual;
            this.actual = actual;
            this.parent = parent;
        }

        MonoTerminalPeekSubscriber(CoreSubscriber<? super T> actual, MonoPeekTerminal<T> parent) {
            this.actual = actual;
            this.actualConditional = null;
            this.parent = parent;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED) {
                return this.done;
            }
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.s = s;
            this.queueSubscription = Operators.as(s);
            this.actual.onSubscribe(this);
        }

        public void onNext(T t) {
            if (this.sourceMode == 2) {
                this.actual.onNext(null);
            } else {
                if (this.done) {
                    Operators.onNextDropped(t, this.actual.currentContext());
                    return;
                }
                this.valued = true;
                if (this.parent.onSuccessCall != null) {
                    try {
                        this.parent.onSuccessCall.accept(t);
                    }
                    catch (Throwable e) {
                        this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                        return;
                    }
                }
                this.actual.onNext(t);
                if (this.parent.onAfterTerminateCall != null) {
                    try {
                        this.parent.onAfterTerminateCall.accept(t, null);
                    }
                    catch (Throwable e) {
                        Operators.onErrorDropped(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()), this.actual.currentContext());
                    }
                }
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.actual.currentContext());
                return false;
            }
            if (this.actualConditional == null) {
                this.onNext(t);
                return false;
            }
            this.valued = true;
            if (this.parent.onSuccessCall != null) {
                try {
                    this.parent.onSuccessCall.accept(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()));
                    return false;
                }
            }
            boolean r = this.actualConditional.tryOnNext(t);
            if (this.parent.onAfterTerminateCall != null) {
                try {
                    this.parent.onAfterTerminateCall.accept(t, null);
                }
                catch (Throwable e) {
                    Operators.onErrorDropped(Operators.onOperatorError(this.s, e, t, this.actual.currentContext()), this.actual.currentContext());
                }
            }
            return r;
        }

        public void onError(Throwable t) {
            block9: {
                if (this.done) {
                    Operators.onErrorDropped(t, this.actual.currentContext());
                    return;
                }
                this.done = true;
                Consumer<? super Throwable> onError = this.parent.onErrorCall;
                if (!this.valued && onError != null) {
                    try {
                        onError.accept(t);
                    }
                    catch (Throwable e) {
                        t = Operators.onOperatorError(null, e, t, this.actual.currentContext());
                    }
                }
                try {
                    this.actual.onError(t);
                }
                catch (UnsupportedOperationException use) {
                    if (onError != null && (Exceptions.isErrorCallbackNotImplemented(use) || use.getCause() == t)) break block9;
                    throw use;
                }
            }
            if (!this.valued && this.parent.onAfterTerminateCall != null) {
                try {
                    this.parent.onAfterTerminateCall.accept(null, t);
                }
                catch (Throwable e) {
                    Operators.onErrorDropped(Operators.onOperatorError(e, this.actual.currentContext()), this.actual.currentContext());
                }
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            if (this.sourceMode == 0 && !this.valued && this.parent.onSuccessCall != null) {
                try {
                    this.parent.onSuccessCall.accept(null);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, this.actual.currentContext()));
                    return;
                }
            }
            this.done = true;
            this.actual.onComplete();
            if (this.sourceMode == 0 && !this.valued && this.parent.onAfterTerminateCall != null) {
                try {
                    this.parent.onAfterTerminateCall.accept(null, null);
                }
                catch (Throwable e) {
                    Operators.onErrorDropped(Operators.onOperatorError(e, this.actual.currentContext()), this.actual.currentContext());
                }
            }
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        @Nullable
        public T poll() {
            assert (this.queueSubscription != null);
            boolean d = this.done;
            Object v = this.queueSubscription.poll();
            if (!this.valued && (v != null || d || this.sourceMode == 1)) {
                this.valued = true;
                if (this.parent.onSuccessCall != null) {
                    try {
                        this.parent.onSuccessCall.accept(v);
                    }
                    catch (Throwable e) {
                        throw Exceptions.propagate(Operators.onOperatorError(this.s, e, v, this.actual.currentContext()));
                    }
                }
                if (this.parent.onAfterTerminateCall != null) {
                    try {
                        this.parent.onAfterTerminateCall.accept(v, null);
                    }
                    catch (Throwable t) {
                        Operators.onErrorDropped(Operators.onOperatorError(t, this.actual.currentContext()), this.actual.currentContext());
                    }
                }
            }
            return (T)v;
        }

        @Override
        public boolean isEmpty() {
            return this.queueSubscription == null || this.queueSubscription.isEmpty();
        }

        @Override
        public void clear() {
            assert (this.queueSubscription != null);
            this.queueSubscription.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m = this.queueSubscription == null ? 0 : ((requestedMode & 4) != 0 ? 0 : this.queueSubscription.requestFusion(requestedMode));
            this.sourceMode = m;
            return m;
        }

        @Override
        public int size() {
            return this.queueSubscription == null ? 0 : this.queueSubscription.size();
        }
    }
}

