/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.async.ResultCursorsHolder;
import org.neo4j.driver.internal.cursor.AsyncResultCursor;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;

public class UnmanagedTransaction {
    private final Connection connection;
    private final BoltProtocol protocol;
    private final BookmarkHolder bookmarkHolder;
    private final ResultCursorsHolder resultCursors;
    private final long fetchSize;
    private volatile State state = State.ACTIVE;

    public UnmanagedTransaction(Connection connection, BookmarkHolder bookmarkHolder, long fetchSize) {
        this.connection = connection;
        this.protocol = connection.protocol();
        this.bookmarkHolder = bookmarkHolder;
        this.resultCursors = new ResultCursorsHolder();
        this.fetchSize = fetchSize;
    }

    public CompletionStage<UnmanagedTransaction> beginAsync(Bookmark initialBookmark, TransactionConfig config) {
        return this.protocol.beginTransaction(this.connection, initialBookmark, config).handle((ignore, beginError) -> {
            if (beginError != null) {
                this.connection.release();
                throw Futures.asCompletionException(beginError);
            }
            return this;
        });
    }

    public CompletionStage<Void> closeAsync() {
        if (this.isOpen()) {
            return this.rollbackAsync();
        }
        return Futures.completedWithNull();
    }

    public CompletionStage<Void> commitAsync() {
        if (this.state == State.COMMITTED) {
            return Futures.failedFuture(new ClientException("Can't commit, transaction has been committed"));
        }
        if (this.state == State.ROLLED_BACK) {
            return Futures.failedFuture(new ClientException("Can't commit, transaction has been rolled back"));
        }
        return this.resultCursors.retrieveNotConsumedError().thenCompose(error -> this.doCommitAsync().handle(UnmanagedTransaction.handleCommitOrRollback(error))).whenComplete((ignore, error) -> this.transactionClosed(error == null));
    }

    public CompletionStage<Void> rollbackAsync() {
        if (this.state == State.COMMITTED) {
            return Futures.failedFuture(new ClientException("Can't rollback, transaction has been committed"));
        }
        if (this.state == State.ROLLED_BACK) {
            return Futures.failedFuture(new ClientException("Can't rollback, transaction has been rolled back"));
        }
        return this.resultCursors.retrieveNotConsumedError().thenCompose(error -> this.doRollbackAsync().handle(UnmanagedTransaction.handleCommitOrRollback(error))).whenComplete((ignore, error) -> this.transactionClosed(false));
    }

    public CompletionStage<ResultCursor> runAsync(Query query, boolean waitForRunResponse) {
        this.ensureCanRunQueries();
        CompletionStage<AsyncResultCursor> cursorStage = this.protocol.runInUnmanagedTransaction(this.connection, query, this, waitForRunResponse, this.fetchSize).asyncResult();
        this.resultCursors.add(cursorStage);
        return cursorStage.thenApply(cursor -> cursor);
    }

    public CompletionStage<RxResultCursor> runRx(Query query) {
        this.ensureCanRunQueries();
        CompletionStage<RxResultCursor> cursorStage = this.protocol.runInUnmanagedTransaction(this.connection, query, this, false, this.fetchSize).rxResult();
        this.resultCursors.add(cursorStage);
        return cursorStage;
    }

    public boolean isOpen() {
        return this.state != State.COMMITTED && this.state != State.ROLLED_BACK;
    }

    public void markTerminated() {
        this.state = State.TERMINATED;
    }

    public Connection connection() {
        return this.connection;
    }

    private void ensureCanRunQueries() {
        if (this.state == State.COMMITTED) {
            throw new ClientException("Cannot run more queries in this transaction, it has been committed");
        }
        if (this.state == State.ROLLED_BACK) {
            throw new ClientException("Cannot run more queries in this transaction, it has been rolled back");
        }
        if (this.state == State.TERMINATED) {
            throw new ClientException("Cannot run more queries in this transaction, it has either experienced an fatal error or was explicitly terminated");
        }
    }

    private CompletionStage<Void> doCommitAsync() {
        if (this.state == State.TERMINATED) {
            return Futures.failedFuture(new ClientException("Transaction can't be committed. It has been rolled back either because of an error or explicit termination"));
        }
        return this.protocol.commitTransaction(this.connection).thenAccept(this.bookmarkHolder::setBookmark);
    }

    private CompletionStage<Void> doRollbackAsync() {
        if (this.state == State.TERMINATED) {
            return Futures.completedWithNull();
        }
        return this.protocol.rollbackTransaction(this.connection);
    }

    private static BiFunction<Void, Throwable, Void> handleCommitOrRollback(Throwable cursorFailure) {
        return (ignore, commitOrRollbackError) -> {
            CompletionException combinedError = Futures.combineErrors(cursorFailure, commitOrRollbackError);
            if (combinedError != null) {
                throw combinedError;
            }
            return null;
        };
    }

    private void transactionClosed(boolean isCommitted) {
        this.state = isCommitted ? State.COMMITTED : State.ROLLED_BACK;
        this.connection.release();
    }

    private static enum State {
        ACTIVE,
        TERMINATED,
        COMMITTED,
        ROLLED_BACK;

    }
}

