/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Consumer;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Exceptions;
import org.neo4j.driver.internal.shaded.reactor.core.Fuseable;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Flux;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.InnerOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.InternalFluxOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.neo4j.driver.internal.shaded.reactor.util.concurrent.Queues;
import org.neo4j.driver.internal.shaded.reactor.util.context.Context;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class FluxOnBackpressureBuffer<O>
extends InternalFluxOperator<O, O>
implements Fuseable {
    final Consumer<? super O> onOverflow;
    final int bufferSize;
    final boolean unbounded;

    FluxOnBackpressureBuffer(Flux<? extends O> source, int bufferSize, boolean unbounded, @Nullable Consumer<? super O> onOverflow) {
        super(source);
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer Size must be strictly positive");
        }
        this.bufferSize = bufferSize;
        this.unbounded = unbounded;
        this.onOverflow = onOverflow;
    }

    @Override
    public CoreSubscriber<? super O> subscribeOrReturn(CoreSubscriber<? super O> actual) {
        return new BackpressureBufferSubscriber<O>(actual, this.bufferSize, this.unbounded, this.onOverflow);
    }

    @Override
    public int getPrefetch() {
        return Integer.MAX_VALUE;
    }

    static final class BackpressureBufferSubscriber<T>
    implements Fuseable.QueueSubscription<T>,
    InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        final Context ctx;
        final Queue<T> queue;
        final int capacityOrSkip;
        final Consumer<? super T> onOverflow;
        Subscription s;
        volatile boolean cancelled;
        volatile boolean enabledFusion;
        volatile boolean done;
        Throwable error;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<BackpressureBufferSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(BackpressureBufferSubscriber.class, "wip");
        volatile long requested;
        static final AtomicLongFieldUpdater<BackpressureBufferSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(BackpressureBufferSubscriber.class, "requested");

        BackpressureBufferSubscriber(CoreSubscriber<? super T> actual, int bufferSize, boolean unbounded, @Nullable Consumer<? super T> onOverflow) {
            this.actual = actual;
            this.ctx = actual.currentContext();
            this.onOverflow = onOverflow;
            Queue q = unbounded ? Queues.unbounded(bufferSize).get() : Queues.get(bufferSize).get();
            this.capacityOrSkip = !unbounded && Queues.capacity(q) > bufferSize ? bufferSize : Integer.MAX_VALUE;
            this.queue = q;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requested;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.done && this.queue.isEmpty();
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.cancelled;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.queue.size();
            }
            if (key == Scannable.Attr.ERROR) {
                return this.error;
            }
            if (key == Scannable.Attr.PREFETCH) {
                return Integer.MAX_VALUE;
            }
            if (key == Scannable.Attr.DELAY_ERROR) {
                return true;
            }
            if (key == Scannable.Attr.CAPACITY) {
                return this.capacityOrSkip == Integer.MAX_VALUE ? Queues.capacity(this.queue) : this.capacityOrSkip;
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t, this.ctx);
                return;
            }
            if (this.capacityOrSkip != Integer.MAX_VALUE && this.queue.size() >= this.capacityOrSkip || !this.queue.offer(t)) {
                Throwable ex = Operators.onOperatorError(this.s, Exceptions.failWithOverflow(), t, this.ctx);
                if (this.onOverflow != null) {
                    try {
                        this.onOverflow.accept(t);
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal(e);
                        ex.initCause(e);
                    }
                }
                Operators.onDiscard(t, this.ctx);
                this.onError(ex);
                return;
            }
            this.drain();
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t, this.ctx);
                return;
            }
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            int missed = 1;
            do {
                CoreSubscriber<? super T> a;
                if ((a = this.actual) == null) continue;
                if (this.enabledFusion) {
                    this.drainFused(a);
                } else {
                    this.drainRegular(a);
                }
                return;
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        void drainRegular(Subscriber<? super T> a) {
            int missed = 1;
            Queue<T> q = this.queue;
            do {
                long e;
                long r = this.requested;
                for (e = 0L; r != e; ++e) {
                    boolean empty;
                    boolean d = this.done;
                    T t = q.poll();
                    boolean bl = empty = t == null;
                    if (this.checkTerminated(d, empty, a)) {
                        return;
                    }
                    if (empty) break;
                    a.onNext(t);
                }
                if (r == e && this.checkTerminated(this.done, q.isEmpty(), a)) {
                    return;
                }
                if (e == 0L || r == Long.MAX_VALUE) continue;
                REQUESTED.addAndGet(this, -e);
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        void drainFused(Subscriber<? super T> a) {
            int missed = 1;
            Queue<T> q = this.queue;
            do {
                if (this.cancelled) {
                    this.s.cancel();
                    Operators.onDiscardQueueWithClear(q, this.ctx, null);
                    return;
                }
                boolean d = this.done;
                a.onNext(null);
                if (!d) continue;
                Throwable ex = this.error;
                if (ex != null) {
                    a.onError(ex);
                } else {
                    a.onComplete();
                }
                return;
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.addCap(REQUESTED, this, n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                if (!this.enabledFusion && WIP.getAndIncrement(this) == 0) {
                    Operators.onDiscardQueueWithClear(this.queue, this.ctx, null);
                }
            }
        }

        @Override
        @Nullable
        public T poll() {
            return this.queue.poll();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public void clear() {
            Operators.onDiscardQueueWithClear(this.queue, this.ctx, null);
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                this.enabledFusion = true;
                return 2;
            }
            return 0;
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<? super T> a) {
            if (this.cancelled) {
                this.s.cancel();
                Operators.onDiscardQueueWithClear(this.queue, this.ctx, null);
                return true;
            }
            if (d && empty) {
                Throwable e = this.error;
                if (e != null) {
                    a.onError(e);
                } else {
                    a.onComplete();
                }
                return true;
            }
            return false;
        }
    }
}

