/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.driver.internal.BoltServerAddress;

public class AddressSet {
    private static final BoltServerAddress[] NONE = new BoltServerAddress[0];
    private volatile BoltServerAddress[] addresses = NONE;

    public BoltServerAddress[] toArray() {
        return this.addresses;
    }

    public int size() {
        return this.addresses.length;
    }

    public synchronized void retainAllAndAdd(Set<BoltServerAddress> newAddresses) {
        BoltServerAddress[] addressesArr = new BoltServerAddress[newAddresses.size()];
        int insertionIdx = 0;
        for (BoltServerAddress address : this.addresses) {
            if (!newAddresses.remove(address)) continue;
            addressesArr[insertionIdx] = address;
            ++insertionIdx;
        }
        Iterator<BoltServerAddress> addressIterator = newAddresses.iterator();
        while (insertionIdx < addressesArr.length && addressIterator.hasNext()) {
            addressesArr[insertionIdx] = addressIterator.next();
            ++insertionIdx;
        }
        this.addresses = addressesArr;
    }

    public synchronized void replaceIfPresent(BoltServerAddress oldAddress, BoltServerAddress newAddress) {
        for (int i = 0; i < this.addresses.length; ++i) {
            if (!this.addresses[i].equals(oldAddress)) continue;
            this.addresses[i] = newAddress;
        }
    }

    public synchronized void remove(BoltServerAddress address) {
        BoltServerAddress[] addresses = this.addresses;
        if (addresses != null) {
            for (int i = 0; i < addresses.length; ++i) {
                if (!addresses[i].equals(address)) continue;
                if (addresses.length == 1) {
                    this.addresses = NONE;
                    return;
                }
                BoltServerAddress[] copy = new BoltServerAddress[addresses.length - 1];
                System.arraycopy(addresses, 0, copy, 0, i);
                System.arraycopy(addresses, i + 1, copy, i, addresses.length - i - 1);
                this.addresses = copy;
                return;
            }
        }
    }

    public String toString() {
        return "AddressSet=" + Arrays.toString(this.addresses);
    }
}

