/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntSupplier;
import org.neo4j.driver.ConnectionPoolMetrics;
import org.neo4j.driver.Metrics;
import org.neo4j.driver.internal.metrics.ConnectionPoolMetricsListener;
import org.neo4j.driver.internal.metrics.DevNullPoolMetricsListener;
import org.neo4j.driver.internal.metrics.ListenerEvent;
import org.neo4j.driver.internal.metrics.MetricsListener;
import org.neo4j.driver.internal.metrics.MicrometerConnectionPoolMetrics;
import org.neo4j.driver.internal.metrics.MicrometerTimerListenerEvent;
import org.neo4j.driver.net.ServerAddress;

final class MicrometerMetrics
implements Metrics,
MetricsListener {
    private final MeterRegistry meterRegistry;
    private final Map<String, ConnectionPoolMetrics> connectionPoolMetrics;

    public MicrometerMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        this.connectionPoolMetrics = new ConcurrentHashMap<String, ConnectionPoolMetrics>();
    }

    @Override
    public Collection<ConnectionPoolMetrics> connectionPoolMetrics() {
        return Collections.unmodifiableCollection(this.connectionPoolMetrics.values());
    }

    @Override
    public void beforeCreating(String poolId, ListenerEvent<?> creatingEvent) {
        this.poolMetricsListener(poolId).beforeCreating(creatingEvent);
    }

    @Override
    public void afterCreated(String poolId, ListenerEvent<?> creatingEvent) {
        this.poolMetricsListener(poolId).afterCreated(creatingEvent);
    }

    @Override
    public void afterFailedToCreate(String poolId) {
        this.poolMetricsListener(poolId).afterFailedToCreate();
    }

    @Override
    public void afterClosed(String poolId) {
        this.poolMetricsListener(poolId).afterClosed();
    }

    @Override
    public void beforeAcquiringOrCreating(String poolId, ListenerEvent<?> acquireEvent) {
        this.poolMetricsListener(poolId).beforeAcquiringOrCreating(acquireEvent);
    }

    @Override
    public void afterAcquiringOrCreating(String poolId) {
        this.poolMetricsListener(poolId).afterAcquiringOrCreating();
    }

    @Override
    public void afterAcquiredOrCreated(String poolId, ListenerEvent<?> acquireEvent) {
        this.poolMetricsListener(poolId).afterAcquiredOrCreated(acquireEvent);
    }

    @Override
    public void afterTimedOutToAcquireOrCreate(String poolId) {
        this.poolMetricsListener(poolId).afterTimedOutToAcquireOrCreate();
    }

    @Override
    public void afterConnectionCreated(String poolId, ListenerEvent<?> inUseEvent) {
        this.poolMetricsListener(poolId).acquired(inUseEvent);
    }

    @Override
    public void afterConnectionReleased(String poolId, ListenerEvent<?> inUseEvent) {
        this.poolMetricsListener(poolId).released(inUseEvent);
    }

    @Override
    public ListenerEvent<?> createListenerEvent() {
        return new MicrometerTimerListenerEvent(this.meterRegistry);
    }

    @Override
    public void registerPoolMetrics(String poolId, ServerAddress address, IntSupplier inUseSupplier, IntSupplier idleSupplier) {
        this.connectionPoolMetrics.put(poolId, new MicrometerConnectionPoolMetrics(poolId, address, inUseSupplier, idleSupplier, this.meterRegistry));
    }

    void putPoolMetrics(String poolId, ConnectionPoolMetrics poolMetrics) {
        this.connectionPoolMetrics.put(poolId, poolMetrics);
    }

    @Override
    public void removePoolMetrics(String poolId) {
        this.connectionPoolMetrics.remove(poolId);
    }

    private ConnectionPoolMetricsListener poolMetricsListener(String poolId) {
        ConnectionPoolMetricsListener poolMetrics = (ConnectionPoolMetricsListener)((Object)this.connectionPoolMetrics.get(poolId));
        if (poolMetrics == null) {
            return DevNullPoolMetricsListener.INSTANCE;
        }
        return poolMetrics;
    }
}

