/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.spi;

import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.async.TerminationAwareStateLockingExecutor;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.spi.ResponseHandler;

public interface Connection {
    public boolean isOpen();

    public void enableAutoRead();

    public void disableAutoRead();

    public void write(Message var1, ResponseHandler var2);

    public void writeAndFlush(Message var1, ResponseHandler var2);

    public boolean isTelemetryEnabled();

    public CompletionStage<Void> reset(Throwable var1);

    public CompletionStage<Void> release();

    public void terminateAndRelease(String var1);

    public String serverAgent();

    public BoltServerAddress serverAddress();

    public BoltProtocol protocol();

    public void bindTerminationAwareStateLockingExecutor(TerminationAwareStateLockingExecutor var1);

    default public AccessMode mode() {
        throw new UnsupportedOperationException(String.format("%s does not support access mode.", this.getClass()));
    }

    default public DatabaseName databaseName() {
        throw new UnsupportedOperationException(String.format("%s does not support database name.", this.getClass()));
    }

    default public String impersonatedUser() {
        throw new UnsupportedOperationException(String.format("%s does not support impersonated user.", this.getClass()));
    }
}

