/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;

class WrappingFileHandle
implements FileHandle {
    private final File file;
    private final File baseDirectory;
    private final FileSystemAbstraction fs;

    WrappingFileHandle(File file, File baseDirectory, FileSystemAbstraction fs) {
        this.file = file;
        this.baseDirectory = baseDirectory;
        this.fs = fs;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public File getRelativeFile() {
        int baseLength = this.baseDirectory.getPath().length();
        if (this.baseDirectory.getParent() != null) {
            ++baseLength;
        }
        return new File(this.file.getPath().substring(baseLength));
    }

    @Override
    public void rename(File to, CopyOption ... options) throws IOException {
        File parentFile = this.file.getParentFile();
        File cannonicalTarget = to.getCanonicalFile();
        this.fs.mkdirs(cannonicalTarget.getParentFile());
        this.fs.renameFile(this.file, cannonicalTarget, options);
        this.removeEmptyParent(parentFile);
    }

    private void removeEmptyParent(File parentFile) {
        File end = this.baseDirectory.getParentFile();
        while (parentFile != null && !parentFile.equals(end)) {
            File[] files = this.fs.listFiles(parentFile);
            if (files == null || files.length > 0) {
                return;
            }
            this.fs.deleteFile(parentFile);
            parentFile = parentFile.getParentFile();
        }
    }

    @Override
    public void delete() throws IOException {
        File parentFile = this.file.getParentFile();
        this.fs.deleteFileOrThrow(this.file);
        this.removeEmptyParent(parentFile);
    }
}

