/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;

public final class PagedReadableByteChannel
implements ReadableByteChannel {
    private final PageCursor cursor;
    private boolean open = true;
    private int bytesLeftInCurrentPage;

    public PagedReadableByteChannel(PagedFile pagedFile) throws IOException {
        this.cursor = pagedFile.io(0L, 9);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        if (this.bytesLeftInCurrentPage == 0) {
            if (this.cursor.next()) {
                this.bytesLeftInCurrentPage = this.cursor.getCurrentPageSize();
            } else {
                return -1;
            }
        }
        int position = dst.position();
        int remaining = Math.min(dst.remaining(), this.bytesLeftInCurrentPage);
        int offset = this.cursor.getOffset();
        do {
            dst.position(position);
            this.cursor.setOffset(offset);
            for (int i = 0; i < remaining; ++i) {
                dst.put(this.cursor.getByte());
            }
        } while (this.cursor.shouldRetry());
        this.bytesLeftInCurrentPage -= remaining;
        return remaining;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() {
        this.open = false;
        this.cursor.close();
    }
}

