/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.result.adapter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.response.model.DefaultGraphModel;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.neo4j.ogm.result.adapter.BaseAdapter;
import org.neo4j.ogm.result.adapter.ResultAdapter;

public abstract class GraphModelAdapter
extends BaseAdapter
implements ResultAdapter<Map<String, Object>, GraphModel> {
    @Override
    public GraphModel adapt(Map<String, Object> data) {
        HashSet<Long> nodeIdentities = new HashSet<Long>();
        HashSet<Long> edgeIdentities = new HashSet<Long>();
        DefaultGraphModel graphModel = new DefaultGraphModel();
        for (Map.Entry<String, Object> mapEntry : data.entrySet()) {
            Object value = mapEntry.getValue();
            String resultKey = mapEntry.getKey();
            boolean generatedNodes = ResultAdapter.describesGeneratedNode(resultKey);
            this.adaptInternal(nodeIdentities, edgeIdentities, graphModel, value, generatedNodes);
        }
        return graphModel;
    }

    private void adaptInternal(Set<Long> nodeIdentities, Set<Long> edgeIdentities, DefaultGraphModel graphModel, Object value, boolean generatedNodes) {
        if (this.isPath(value)) {
            this.buildPath(value, graphModel, nodeIdentities, edgeIdentities, generatedNodes);
        } else if (this.isNode(value)) {
            this.buildNode(value, graphModel, nodeIdentities, generatedNodes);
        } else if (this.isRelationship(value)) {
            this.buildRelationship(value, graphModel, edgeIdentities);
        } else if (value instanceof Iterable) {
            Iterable collection = (Iterable)value;
            for (Object element : collection) {
                this.adaptInternal(nodeIdentities, edgeIdentities, graphModel, element, generatedNodes);
            }
        }
    }

    void buildPath(Object path, DefaultGraphModel graphModel, Set nodeIdentities, Set edgeIdentities, boolean generatedNodes) {
        Iterator<Object> relIterator = this.relsInPath(path).iterator();
        Iterator<Object> nodeIterator = this.nodesInPath(path).iterator();
        while (relIterator.hasNext()) {
            this.buildRelationship(relIterator.next(), graphModel, edgeIdentities);
        }
        while (nodeIterator.hasNext()) {
            this.buildNode(nodeIterator.next(), graphModel, nodeIdentities, generatedNodes);
        }
    }

    void buildNode(Object node, DefaultGraphModel graphModel, Set<Long> nodeIdentities, boolean generatedNode) {
        long nativeId = this.nodeId(node);
        if (nodeIdentities.contains(nativeId)) {
            return;
        }
        nodeIdentities.add(nativeId);
        NodeModel nodeModel = new NodeModel(nativeId);
        List<String> labels = this.labels(node);
        nodeModel.setLabels(labels.toArray(new String[0]));
        nodeModel.setProperties(this.convertArrayPropertiesToCollection(this.properties(node)));
        nodeModel.setGeneratedNode(generatedNode);
        graphModel.addNode(nodeModel);
    }

    void buildRelationship(Object relationship, DefaultGraphModel graphModel, Set<Long> edgeIdentities) {
        if (edgeIdentities.contains(this.relationshipId(relationship))) {
            return;
        }
        edgeIdentities.add(this.relationshipId(relationship));
        RelationshipModel edgeModel = new RelationshipModel();
        edgeModel.setId(this.relationshipId(relationship));
        edgeModel.setType(this.relationshipType(relationship));
        edgeModel.setStartNode(this.startNodeId(relationship));
        edgeModel.setEndNode(this.endNodeId(relationship));
        edgeModel.setProperties(this.convertArrayPropertiesToCollection(this.properties(relationship)));
        graphModel.addRelationship(edgeModel);
    }

    public abstract boolean isPath(Object var1);

    public abstract boolean isNode(Object var1);

    public abstract boolean isRelationship(Object var1);

    public abstract long nodeId(Object var1);

    public abstract List<String> labels(Object var1);

    public abstract long relationshipId(Object var1);

    public abstract String relationshipType(Object var1);

    public abstract Long startNodeId(Object var1);

    public abstract Long endNodeId(Object var1);

    public abstract Map<String, Object> properties(Object var1);

    public abstract List<Object> nodesInPath(Object var1);

    public abstract List<Object> relsInPath(Object var1);
}

