/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler.builders.statement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.neo4j.ogm.cypher.compiler.CypherStatementBuilder;
import org.neo4j.ogm.cypher.compiler.builders.statement.BaseBuilder;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.model.Property;
import org.neo4j.ogm.model.PropertyContainer;
import org.neo4j.ogm.request.OptimisticLockingConfig;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;

public class ExistingNodeStatementBuilder
extends BaseBuilder
implements CypherStatementBuilder {
    private final StatementFactory statementFactory;
    private final Set<Node> existingNodes;

    public ExistingNodeStatementBuilder(Set<Node> existingNodes, StatementFactory statementFactory) {
        this.existingNodes = existingNodes;
        this.statementFactory = statementFactory;
    }

    @Override
    public Statement build() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        StringBuilder queryBuilder = new StringBuilder();
        if (this.existingNodes != null && this.existingNodes.size() > 0) {
            Node firstNode = this.existingNodes.iterator().next();
            queryBuilder.append("UNWIND {rows} as row ").append("MATCH (n) WHERE ID(n)=row.nodeId ");
            if (firstNode.hasVersionProperty()) {
                this.appendVersionPropertyCheck(queryBuilder, (PropertyContainer)firstNode, "n");
            }
            Set previousDynamicLabels = firstNode.getPreviousDynamicLabels();
            for (String label : previousDynamicLabels) {
                queryBuilder.append(String.format(" REMOVE n:`%s` ", label));
            }
            queryBuilder.append(firstNode.createPropertyRemovalFragment("n"));
            queryBuilder.append("SET n");
            for (String label : firstNode.getLabels()) {
                queryBuilder.append(":`").append(label).append("`");
            }
            queryBuilder.append(" SET n += row.props RETURN row.nodeId as ref, ID(n) as id, {type} as type");
            ArrayList rows = new ArrayList();
            for (Node node : this.existingNodes) {
                HashMap<String, Object> rowMap = new HashMap<String, Object>();
                rowMap.put("nodeId", node.getId());
                HashMap<String, Object> props = new HashMap<String, Object>();
                for (Property property : node.getPropertyList()) {
                    if (property.equals(node.getVersion())) continue;
                    props.put((String)property.getKey(), property.getValue());
                }
                rowMap.put("props", props);
                if (node.hasVersionProperty()) {
                    Property version = node.getVersion();
                    rowMap.put((String)version.getKey(), version.getValue());
                }
                rows.add(rowMap);
            }
            parameters.put("type", "node");
            parameters.put("rows", rows);
            if (firstNode.hasVersionProperty()) {
                OptimisticLockingConfig olConfig = new OptimisticLockingConfig(rows.size(), firstNode.getLabels(), (String)firstNode.getVersion().getKey());
                return this.statementFactory.statement(queryBuilder.toString(), parameters, olConfig);
            }
        }
        return this.statementFactory.statement(queryBuilder.toString(), parameters);
    }
}

