/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request;

import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.session.request.MatchClause;

public class RelationshipPropertyMatchClause
implements MatchClause {
    private int index;
    private String relationshipType;
    private StringBuilder clause;

    public RelationshipPropertyMatchClause(int index, String relationshipType) {
        this.index = index;
        this.relationshipType = relationshipType;
    }

    @Override
    public MatchClause append(Filter filter) {
        if (this.clause == null) {
            this.clause = new StringBuilder("MATCH (n)");
            if (filter.getRelationshipDirection().equals("INCOMING")) {
                this.clause.append("<");
            }
            this.clause.append(String.format("-[%s:`%s`]-", this.relationshipIdentifier(), this.relationshipType));
            if (filter.getRelationshipDirection().equals("OUTGOING")) {
                this.clause.append(">");
            }
            this.clause.append(String.format("(%s) ", this.nodeIdentifier()));
        }
        this.clause.append(filter.toCypher(this.relationshipIdentifier(), this.clause.indexOf(" WHERE ") == -1));
        return this;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    @Override
    public String toCypher() {
        return this.clause.toString();
    }

    private String nodeIdentifier() {
        return "m" + this.index;
    }

    private String relationshipIdentifier() {
        return "r" + this.index;
    }
}

