/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class DateCollectionStringConverter
implements AttributeConverter<Collection<Date>, String[]> {
    private SimpleDateFormat simpleDateFormat;
    private final Class<? extends Collection> collectionClass;

    public DateCollectionStringConverter(String userDefinedFormat, Class<? extends Collection> collectionClass) {
        this.collectionClass = collectionClass;
        this.simpleDateFormat = new SimpleDateFormat(userDefinedFormat);
        this.simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public String[] toGraphProperty(Collection<Date> value) {
        if (value == null) {
            return null;
        }
        String[] values = new String[value.size()];
        int i = 0;
        for (Date date : value) {
            values[i++] = this.simpleDateFormat.format(date);
        }
        return values;
    }

    @Override
    public Collection<Date> toEntityAttribute(String[] dateValues) {
        ArrayList<Date> values;
        if (dateValues == null) {
            return null;
        }
        if (List.class.isAssignableFrom(this.collectionClass)) {
            values = new ArrayList(dateValues.length);
        } else if (Vector.class.isAssignableFrom(this.collectionClass)) {
            values = new Vector(dateValues.length);
        } else if (Set.class.isAssignableFrom(this.collectionClass)) {
            values = new HashSet(dateValues.length);
        } else {
            return null;
        }
        try {
            for (String value : dateValues) {
                values.add(this.simpleDateFormat.parse(value));
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return values;
    }
}

