/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class InstantStringConverter
implements AttributeConverter<Instant, String> {
    private final DateTimeFormatter formatter = DateTimeFormatter.ISO_INSTANT;

    @Override
    public String toGraphProperty(Instant value) {
        if (value == null) {
            return null;
        }
        return this.formatter.format(value);
    }

    @Override
    public Instant toEntityAttribute(String value) {
        if (value == null) {
            return null;
        }
        return Instant.parse(value);
    }
}

