/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.ogm.annotation.Transient;
import org.neo4j.ogm.driver.TypeSystem;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.ObjectAnnotations;
import org.neo4j.ogm.metadata.reflect.GenericUtils;

public class FieldsInfo {
    private final Map<String, FieldInfo> fields = new HashMap<String, FieldInfo>();

    FieldsInfo(ClassInfo classInfo, Class<?> clazz, Field delegateHolder, TypeSystem typeSystem) {
        ArrayList<Field> allFieldsInfluencedByThisClass = new ArrayList<Field>();
        allFieldsInfluencedByThisClass.addAll(FieldsInfo.getGenericOrParameterizedFieldsInHierarchyOf(clazz));
        allFieldsInfluencedByThisClass.addAll(Arrays.asList(clazz.getDeclaredFields()));
        for (Field field : allFieldsInfluencedByThisClass) {
            ObjectAnnotations objectAnnotations;
            int modifiers = field.getModifiers();
            if (field.isSynthetic() || Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers) || (objectAnnotations = ObjectAnnotations.of(field.getDeclaredAnnotations())).has(Transient.class)) continue;
            String typeParameterDescriptor = FieldsInfo.findTypeParameterDescriptor(field, clazz);
            this.fields.put(field.getName(), new FieldInfo(classInfo, delegateHolder, field, typeParameterDescriptor, objectAnnotations, arg_0 -> ((TypeSystem)typeSystem).supportsAsNativeType(arg_0)));
        }
    }

    private static String findTypeParameterDescriptor(Field field, Class<?> clazz) {
        String typeParameterDescriptor = null;
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            typeParameterDescriptor = GenericUtils.findFieldType(field, clazz).getName();
        }
        if (typeParameterDescriptor == null && genericType instanceof TypeVariable) {
            typeParameterDescriptor = field.getType().getTypeName();
        }
        return typeParameterDescriptor;
    }

    private static List<Field> getGenericOrParameterizedFieldsInHierarchyOf(Class<?> clazz) {
        Predicate<Field> predicate = GenericUtils::isGenericField;
        predicate = predicate.or(GenericUtils::isParameterizedField);
        ArrayList<Field> genericFieldsInHierarchy = new ArrayList<Field>();
        for (Class<?> currentClass = clazz.getSuperclass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            Stream.of(currentClass.getDeclaredFields()).filter(predicate).forEach(genericFieldsInHierarchy::add);
        }
        return genericFieldsInHierarchy;
    }

    public Collection<FieldInfo> fields() {
        return this.fields.values();
    }

    public Collection<FieldInfo> compositeFields() {
        ArrayList<FieldInfo> compositeFields = new ArrayList<FieldInfo>();
        for (FieldInfo field : this.fields()) {
            if (!field.hasCompositeConverter()) continue;
            compositeFields.add(field);
        }
        return Collections.unmodifiableList(compositeFields);
    }

    FieldInfo get(String name) {
        return this.fields.get(name);
    }

    public void append(FieldsInfo fieldsInfo) {
        for (FieldInfo fieldInfo : fieldsInfo.fields()) {
            if (this.fields.containsKey(fieldInfo.getName())) continue;
            this.fields.put(fieldInfo.getName(), fieldInfo);
        }
    }
}

