/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.docs.integration;

import org.noear.solon.Utils;
import org.noear.solon.cloud.model.Discovery;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.event.EventListener;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.docs.integration.DiscoverLocator;
import org.noear.solon.docs.integration.properties.DocDocketProperties;
import org.noear.solon.docs.integration.properties.DocsProperties;

public class XPluginImpl
implements Plugin {
    public static final String SOLON_DOCS = "solon.docs";

    public void start(AppContext context) throws Throwable {
        Props docsProps = context.cfg().getProp(SOLON_DOCS);
        DocsProperties docsProperties = docsProps.size() > 0 ? (DocsProperties)docsProps.toBean(DocsProperties.class) : new DocsProperties();
        if (Utils.isNotEmpty(docsProperties.getRoutes())) {
            for (DocDocketProperties docDocket : docsProperties.getRoutes()) {
                if (Utils.isEmpty((String)docDocket.getId())) {
                    throw new IllegalArgumentException("Docs route id is empty");
                }
                BeanWrap docBw = context.wrap(docDocket.getId(), (Object)docDocket);
                context.putWrap(docDocket.getId(), docBw);
                context.wrapPublish(docBw);
            }
        }
        if (docsProperties.getDiscover().isEnabled()) {
            if (ClassUtil.hasClass(() -> Discovery.class)) {
                DiscoverLocator discoverLocator = new DiscoverLocator(context, docsProperties.getDiscover());
                if (docsProperties.getDiscover().isSyncStatus()) {
                    EventBus.subscribe(Discovery.class, (EventListener)discoverLocator);
                }
                context.lifecycle((LifecycleBean)discoverLocator);
            } else {
                LogUtil.global().warn("Solon docs discover: missing solon cloud discovery");
            }
        }
    }
}

