/*
 * Copyright 2017-2024 noear.org and authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.noear.solon.core.wrap;

import org.noear.solon.lang.Nullable;

import java.lang.reflect.ParameterizedType;

/**
 * 字段 变量描述符
 *
 * @author noear
 * @since 2.4
 */
public class ParamWrapSpec extends VarSpecBase {
    private final ParamWrap paramWrap;

    public ParamWrapSpec(ParamWrap paramWrap) {
        super(paramWrap.getParameter(), paramWrap.getParameter().getName());
        this.paramWrap = paramWrap;

        initAction();
    }


    @Override
    public @Nullable ParameterizedType getGenericType() {
        return paramWrap.getGenericType();
    }

    @Override
    public Class<?> getType() {
        return paramWrap.getType();
    }
}
