/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

public final class EnvFont {
    private static Map<String, Font> fMap;
    private static FontRenderContext frCtx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font getFont(String name) {
        if (fMap != null) {
            return fMap.get(name);
        }
        Class<EnvFont> clazz = EnvFont.class;
        synchronized (EnvFont.class) {
            Font[] allFonts;
            fMap = new HashMap<String, Font>();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (Font font : allFonts = ge.getAllFonts()) {
                fMap.put(font.getFontName(), font);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return fMap.get(name);
        }
    }

    public static Font getFont(String name, String family) {
        Font res = EnvFont.getFont(name);
        if (res != null) {
            return res;
        }
        return EnvFont.getFont(family);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Rectangle2D strBounds(String name, String family, String str, double size) {
        if (frCtx == null) {
            Class<EnvFont> clazz = EnvFont.class;
            // MONITORENTER : org.ofdrw.font.EnvFont.class
            frCtx = new FontRenderContext(new AffineTransform(), true, true);
            // MONITOREXIT : clazz
        }
        Font font = EnvFont.getFont(name, family);
        font = font.deriveFont((float)size);
        return font.getStringBounds(str, frCtx);
    }
}

