/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRustCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractRustCodegen.class);
    protected List<String> charactersToAllow = Collections.singletonList("_");
    protected Set<String> keywordsThatDoNotSupportRawIdentifiers = new HashSet<String>(Arrays.asList("super", "self", "Self", "extern", "crate"));
    protected String enumSuffix = "";

    public AbstractRustCodegen() {
        this.reservedWords = new HashSet<String>(Arrays.asList("as", "break", "const", "continue", "crate", "else", "enum", "extern", "false", "fn", "for", "if", "impl", "in", "let", "loop", "match", "mod", "move", "mut", "pub", "ref", "return", "self", "Self", "static", "struct", "super", "trait", "true", "type", "unsafe", "use", "where", "while", "async", "await", "dyn", "abstract", "become", "box", "do", "final", "macro", "override", "priv", "typeof", "unsized", "virtual", "yield", "try"));
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.RUST;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public boolean isReservedWord(String word) {
        return word != null && this.reservedWords.contains(word);
    }

    @VisibleForTesting
    public String bestFittingIntegerType(@Nullable BigInteger minimum, boolean exclusiveMinimum, @Nullable BigInteger maximum, boolean exclusiveMaximum, boolean preferUnsigned) {
        boolean knownRange;
        if (exclusiveMinimum) {
            minimum = Optional.ofNullable(minimum).map(min -> min.add(BigInteger.ONE)).orElse(null);
        }
        if (exclusiveMaximum) {
            maximum = Optional.ofNullable(maximum).map(max -> max.subtract(BigInteger.ONE)).orElse(null);
        }
        boolean guaranteedPositive = Optional.ofNullable(minimum).map(min -> min.signum() >= 0).orElse(false);
        int requiredBits = Math.max(Optional.ofNullable(minimum).map(BigInteger::bitLength).orElse(0), Optional.ofNullable(maximum).map(BigInteger::bitLength).orElse(0));
        boolean bl = knownRange = !Objects.isNull(minimum) && !Objects.isNull(maximum);
        if (guaranteedPositive && preferUnsigned) {
            if (requiredBits <= 8 && knownRange) {
                return "u8";
            }
            if (requiredBits <= 16 && knownRange) {
                return "u16";
            }
            if (requiredBits <= 32) {
                return "u32";
            }
            if (requiredBits <= 64) {
                return "u64";
            }
            if (requiredBits <= 128) {
                return "u128";
            }
        } else {
            if (requiredBits <= 7 && knownRange) {
                return "i8";
            }
            if (requiredBits <= 15 && knownRange) {
                return "i16";
            }
            if (requiredBits <= 31) {
                return "i32";
            }
            if (requiredBits <= 63) {
                return "i64";
            }
            if (requiredBits <= 127) {
                return "i128";
            }
        }
        throw new RuntimeException("Number is too large to fit into i128");
    }

    @VisibleForTesting
    public boolean canFitIntoUnsigned(@Nullable BigInteger minimum, boolean exclusiveMinimum) {
        return Optional.ofNullable(minimum).map(min -> {
            if (exclusiveMinimum) {
                min = min.add(BigInteger.ONE);
            }
            return min.signum() >= 0;
        }).orElse(false);
    }

    public String sanitizeIdentifier(String name, CasingType casingType, String escapePrefix, String type, boolean allowRawIdentifiers) {
        Function<String, String> casingFunction;
        String originalName = name;
        switch (casingType) {
            case CAMEL_CASE: {
                casingFunction = input -> StringUtils.camelize(StringUtils.underscore(input));
                break;
            }
            case SNAKE_CASE: {
                casingFunction = StringUtils::underscore;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown CasingType");
            }
        }
        name = ((String)name).replaceAll("-", "_");
        if (!Strings.isNullOrEmpty((String)name)) {
            boolean endedWithUnderscore = ((String)name).endsWith("_");
            name = StringUtils.escape((String)name, this.specialCharReplacements, this.charactersToAllow, "_");
            if (!endedWithUnderscore && ((String)name).endsWith("_")) {
                name = org.apache.commons.lang3.StringUtils.chop((String)name);
            }
        }
        boolean nameWasModified = !originalName.equals(name = this.sanitizeName((String)name));
        if (((String)(name = casingFunction.apply((String)name))).matches("^\\d.*")) {
            nameWasModified = true;
            name = casingFunction.apply(escapePrefix + "_" + (String)name);
        }
        if (this.isReservedWord((String)name)) {
            nameWasModified = true;
            name = this.keywordsThatDoNotSupportRawIdentifiers.contains(name) || !allowRawIdentifiers ? casingFunction.apply(escapePrefix + "_" + (String)name) : "r#" + (String)name;
        }
        if (nameWasModified) {
            this.LOGGER.warn("{} cannot be used as a {} name. Renamed to {}", new Object[]{casingFunction.apply(originalName), type, name});
        }
        return name;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            String innerType = this.getTypeDeclaration(inner);
            return (String)this.typeMapping.get("array") + "<" + innerType + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            String innerType = this.getTypeDeclaration(inner);
            StringBuilder typeDeclaration = new StringBuilder((String)this.typeMapping.get("map")).append("<").append((String)this.typeMapping.get("string")).append(", ");
            typeDeclaration.append(innerType).append(">");
            return typeDeclaration.toString();
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)p.get$ref())) {
            Object datatype;
            try {
                datatype = this.toModelName(ModelUtils.getSimpleRef(p.get$ref()));
                datatype = "models::" + this.toModelName((String)datatype);
            }
            catch (Exception e) {
                this.LOGGER.warn("Error obtaining the datatype from schema (model):{}. Datatype default to Object", (Object)p);
                datatype = "Object";
                this.LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return datatype;
        }
        if (p instanceof FileSchema) {
            return (String)this.typeMapping.get("file");
        }
        String oasType = this.getSchemaType(p);
        if (this.typeMapping.containsKey(oasType)) {
            return (String)this.typeMapping.get(oasType);
        }
        if (this.typeMapping.containsValue(oasType)) {
            return oasType;
        }
        if (this.languageSpecificPrimitives.contains(oasType)) {
            return oasType;
        }
        return "models::" + this.toModelName(oasType);
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        this.LOGGER.trace("Creating model from schema: {}", (Object)model);
        Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
        CodegenModel mdl = super.fromModel(name, model);
        mdl.vendorExtensions.put("x-upper-case-name", name.toUpperCase(Locale.ROOT));
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)model.get$ref())) {
            Schema schema = allDefinitions.get(ModelUtils.getSimpleRef(model.get$ref()));
            mdl.dataType = (String)this.typeMapping.get(schema.getType());
        }
        if (ModelUtils.isArraySchema(model)) {
            mdl.arrayModelType = this.typeMapping.containsKey(mdl.arrayModelType) ? (String)this.typeMapping.get(mdl.arrayModelType) : this.toModelName(mdl.arrayModelType);
        } else if (!mdl.anyOf.isEmpty() || !mdl.oneOf.isEmpty()) {
            mdl.dataType = this.getSchemaType(model);
        }
        Schema additionalProperties = ModelUtils.getAdditionalProperties(model);
        if (additionalProperties != null) {
            mdl.additionalPropertiesType = this.getTypeDeclaration(additionalProperties);
        }
        this.LOGGER.trace("Created model: {}", (Object)mdl);
        return mdl;
    }

    @Override
    public String toVarName(String name) {
        if (this.nameMapping.containsKey(name)) {
            return (String)this.nameMapping.get(name);
        }
        return this.sanitizeIdentifier(name, CasingType.SNAKE_CASE, "param", "field/variable", true);
    }

    @Override
    public String toParamName(String name) {
        if (this.parameterNameMapping.containsKey(name)) {
            return (String)this.parameterNameMapping.get(name);
        }
        return this.sanitizeIdentifier(name, CasingType.SNAKE_CASE, "param", "parameter", true);
    }

    @Override
    public String toOperationId(String operationId) {
        return this.sanitizeIdentifier(operationId, CasingType.SNAKE_CASE, "call", "method", true);
    }

    protected String addModelNamePrefixAndSuffix(String name) {
        if (!Strings.isNullOrEmpty((String)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + (String)name;
        }
        if (!Strings.isNullOrEmpty((String)this.modelNameSuffix)) {
            name = (String)name + "_" + this.modelNameSuffix;
        }
        return name;
    }

    @Override
    public String toModelName(String name) {
        return this.sanitizeIdentifier(this.addModelNamePrefixAndSuffix(name), CasingType.CAMEL_CASE, "model", "model", false);
    }

    @Override
    public String toModelFilename(String name) {
        return this.sanitizeIdentifier(this.addModelNamePrefixAndSuffix(name), CasingType.SNAKE_CASE, "model", "model file", false);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (this.enumNameMapping.containsKey(name)) {
            return (String)this.enumNameMapping.get(name);
        }
        if (Strings.isNullOrEmpty((String)name)) {
            return "Empty";
        }
        return this.sanitizeIdentifier(name, CasingType.CAMEL_CASE, "variant", "enum variant", true);
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        Object name = property.baseName;
        if (!Strings.isNullOrEmpty((String)this.enumSuffix)) {
            name = (String)name + "_" + this.enumSuffix;
        }
        return this.sanitizeIdentifier((String)name, CasingType.CAMEL_CASE, "enum", "enum", false);
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        return this.escapeText(value);
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return this.toEnumVarName(value, datatype);
    }

    protected String addApiNamePrefixAndSuffix(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            name = "default";
        }
        if (!Strings.isNullOrEmpty((String)this.apiNamePrefix)) {
            name = this.apiNamePrefix + "_" + (String)name;
        }
        if (!Strings.isNullOrEmpty((String)this.apiNameSuffix)) {
            name = (String)name + "_" + this.apiNameSuffix;
        }
        return name;
    }

    @Override
    public String toApiName(String name) {
        return this.sanitizeIdentifier(this.addApiNamePrefixAndSuffix(name), CasingType.CAMEL_CASE, "api", "API", false);
    }

    @Override
    public String toApiFilename(String name) {
        return this.sanitizeIdentifier(this.addApiNamePrefixAndSuffix(name), CasingType.SNAKE_CASE, "api", "API file", false);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String addRegularExpressionDelimiter(String pattern) {
        return pattern;
    }

    public static enum CasingType {
        CAMEL_CASE,
        SNAKE_CASE;

    }
}

