/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.neo4j.driver;

import org.opencypher.gremlin.translation.translator.TranslatorFlavor;

public class Config {
    private final TranslatorFlavor flavor;
    private final boolean ignoreIds;

    private Config(ConfigBuilder configBuilder) {
        this.flavor = configBuilder.flavor;
        this.ignoreIds = configBuilder.ignoreIds;
    }

    public static Config defaultConfig() {
        return Config.build().toConfig();
    }

    public TranslatorFlavor flavor() {
        return this.flavor;
    }

    public boolean translationEnabled() {
        return this.flavor != null;
    }

    public boolean isIgnoreIds() {
        return this.ignoreIds;
    }

    public static ConfigBuilder build() {
        return new ConfigBuilder();
    }

    public static class ConfigBuilder {
        private TranslatorFlavor flavor;
        private boolean ignoreIds = false;

        private ConfigBuilder() {
        }

        public ConfigBuilder withTranslation() {
            this.flavor = TranslatorFlavor.gremlinServer();
            return this;
        }

        public ConfigBuilder withTranslation(TranslatorFlavor flavor) {
            this.flavor = flavor;
            return this;
        }

        public ConfigBuilder ignoreIds() {
            this.ignoreIds = true;
            return this;
        }

        public Config toConfig() {
            return new Config(this);
        }
    }
}

