/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.neo4j.driver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.internal.InternalNode;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.InternalRelationship;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;
import org.neo4j.driver.v1.types.Entity;
import org.opencypher.gremlin.translation.ReturnProperties;

class GremlinCypherValueConverter {
    private final boolean ignoreIds;

    public GremlinCypherValueConverter(boolean ignoreIds) {
        this.ignoreIds = ignoreIds;
    }

    Record toRecord(Map<String, Object> map) {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<Value> values = new ArrayList<Value>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            keys.add(entry.getKey());
            values.add(this.toCypherValue(entry.getValue()));
        }
        return new InternalRecord(keys, values.toArray(new Value[values.size()]));
    }

    private Value toCypherValue(Object value) {
        if (ReturnProperties.isNode((Object)value)) {
            return this.toCypherNode((Map)value).asValue();
        }
        if (ReturnProperties.isRelationship((Object)value)) {
            return this.toCypherRelationship((Map)value).asValue();
        }
        if (ReturnProperties.isPath((Object)value)) {
            return this.toCypherPath((List)value);
        }
        return Values.value((Object)value);
    }

    private Value toCypherPath(List p) {
        boolean isNode = true;
        Entity[] objects = new Entity[p.size()];
        for (int i = 0; i < p.size(); ++i) {
            objects[i] = isNode ? this.toCypherNode((Map)p.get(i)) : this.toCypherRelationship((Map)p.get(i));
            isNode = !isNode;
        }
        return new InternalPath(objects).asValue();
    }

    private InternalRelationship toCypherRelationship(Map<?, ?> e) {
        Long start = this.toCypherId(e.get("_outV"));
        Long end = this.toCypherId(e.get("_inV"));
        Map<String, Value> properties = this.toCypherPropertyMap(e);
        Object id = e.get("_id");
        Object label = e.get("_label");
        return new InternalRelationship(this.toCypherId(id).longValue(), start.longValue(), end.longValue(), String.valueOf(label), properties);
    }

    private InternalNode toCypherNode(Map<?, ?> v) {
        HashSet<String> labels = new HashSet<String>();
        String label = String.valueOf(v.get("_label"));
        if (!"vertex".equals(label)) {
            labels.add(label);
        }
        Map<String, Value> properties = this.toCypherPropertyMap(v);
        return new InternalNode(this.toCypherId(v.get("_id")).longValue(), labels, properties);
    }

    private Map<String, Value> toCypherPropertyMap(Map<?, ?> e) {
        HashMap<String, Value> properties = new HashMap<String, Value>();
        e.entrySet().stream().filter(n -> !ReturnProperties.ALL_PROPERTIES.contains(String.valueOf(n.getKey()))).forEach(n -> properties.put(String.valueOf(n.getKey()), this.toCypherValue(n.getValue())));
        return properties;
    }

    private Long toCypherId(Object id) {
        if (this.ignoreIds) {
            return -1L;
        }
        try {
            return Long.valueOf(String.valueOf(id));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Entity id should be numeric, got `%s` (%s). Consider querying properties instead of entities, or use org.opencypher.gremlin.neo4j.driver.Config.ConfigBuilder#ignoreIds", id.getClass(), id));
        }
    }
}

