/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.neo4j.driver;

import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Cluster;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.summary.ServerInfo;
import org.opencypher.gremlin.client.CypherGremlinClient;
import org.opencypher.gremlin.neo4j.driver.Config;
import org.opencypher.gremlin.neo4j.driver.GremlinCypherValueConverter;
import org.opencypher.gremlin.neo4j.driver.GremlinDriver;
import org.opencypher.gremlin.neo4j.driver.GremlinServerSession;
import org.opencypher.gremlin.translation.translator.TranslatorFlavor;

class GremlinServerDriver
implements GremlinDriver {
    private final Cluster cluster;
    private final GremlinServerInfo serverInfo;
    private final Config config;

    GremlinServerDriver(Cluster cluster, Config config) {
        this.cluster = cluster;
        this.config = config;
        this.serverInfo = new GremlinServerInfo(cluster.toString());
    }

    public boolean isEncrypted() {
        return this.cluster.isSslEnabled();
    }

    public Session session() {
        Client gremlinClient = this.cluster.connect();
        CypherGremlinClient cypherGremlinClient = this.config.translationEnabled() ? CypherGremlinClient.translating((Client)gremlinClient, (TranslatorFlavor)this.config.flavor()) : CypherGremlinClient.plugin((Client)gremlinClient);
        GremlinCypherValueConverter converter = new GremlinCypherValueConverter(this.config.isIgnoreIds());
        return new GremlinServerSession(this.serverInfo, cypherGremlinClient, converter);
    }

    public void close() {
        this.cluster.close();
    }

    static class GremlinServerInfo
    implements ServerInfo {
        private final String address;

        GremlinServerInfo(String address) {
            this.address = address;
        }

        public String address() {
            return this.address;
        }

        public String version() {
            return null;
        }
    }
}

