/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.neo4j.driver;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.driver.v1.Record;
import org.neo4j.driver.v1.Session;
import org.neo4j.driver.v1.Statement;
import org.neo4j.driver.v1.StatementResult;
import org.neo4j.driver.v1.Transaction;
import org.neo4j.driver.v1.TransactionWork;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.summary.ServerInfo;
import org.neo4j.driver.v1.types.TypeSystem;
import org.opencypher.gremlin.client.CypherGremlinClient;
import org.opencypher.gremlin.neo4j.driver.GremlinCypherValueConverter;
import org.opencypher.gremlin.neo4j.driver.GremlinServerStatementResult;

class GremlinServerSession
implements Session {
    private final ServerInfo serverInfo;
    private final CypherGremlinClient client;
    private final GremlinCypherValueConverter converter;
    private boolean open = true;

    GremlinServerSession(ServerInfo serverInfo, CypherGremlinClient client, GremlinCypherValueConverter converter) {
        this.serverInfo = serverInfo;
        this.client = client;
        this.converter = converter;
    }

    public Transaction beginTransaction() {
        throw new UnsupportedOperationException("Transactions are currently not supported");
    }

    public Transaction beginTransaction(String bookmark) {
        throw new UnsupportedOperationException("Transactions are currently not supported");
    }

    public <T> T readTransaction(TransactionWork<T> work) {
        throw new UnsupportedOperationException("Transactions are currently not supported");
    }

    public <T> T writeTransaction(TransactionWork<T> work) {
        throw new UnsupportedOperationException("Transactions are currently not supported");
    }

    public String lastBookmark() {
        throw new UnsupportedOperationException("Transactions are currently not supported");
    }

    public void reset() {
        throw new UnsupportedOperationException("Transactions are currently not supported");
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
        this.open = false;
        this.client.close();
    }

    public StatementResult run(String statementTemplate, Value parameters) {
        return this.run(statementTemplate, parameters.asMap());
    }

    public StatementResult run(String statementTemplate, Record statementParameters) {
        return this.run(statementTemplate, statementParameters.asMap());
    }

    public StatementResult run(String statementTemplate) {
        return this.run(statementTemplate, new HashMap<String, Object>());
    }

    public StatementResult run(String statementTemplate, Map<String, Object> statementParameters) {
        return this.run(new Statement(statementTemplate, statementParameters));
    }

    public StatementResult run(Statement statement) {
        HashMap serializableMap = new HashMap(statement.parameters().asMap());
        Iterator iterator = this.client.submit(statement.text(), serializableMap).iterator();
        return new GremlinServerStatementResult(this.serverInfo, statement, iterator, this.converter);
    }

    public TypeSystem typeSystem() {
        throw new UnsupportedOperationException("TypeSystem is currently not supported");
    }
}

