/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Timer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.http.client.HttpClient;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class FileBackedHTTPMetadataResolver
extends HTTPMetadataResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FileBackedHTTPMetadataResolver.class);
    @Nullable
    private File metadataBackupFile;

    public FileBackedHTTPMetadataResolver(HttpClient client, String metadataURL, String backupFilePath) throws ResolverException {
        this(null, client, metadataURL, backupFilePath);
    }

    public FileBackedHTTPMetadataResolver(Timer backgroundTaskTimer, HttpClient client, String metadataURL, String backupFilePath) throws ResolverException {
        super(backgroundTaskTimer, client, metadataURL);
        this.setBackupFile(backupFilePath);
    }

    @Override
    protected void doDestroy() {
        this.metadataBackupFile = null;
        super.doDestroy();
    }

    @Override
    protected void initMetadataResolver() throws ComponentInitializationException {
        try {
            this.validateBackupFile(this.metadataBackupFile);
        }
        catch (ResolverException e) {
            if (this.isFailFastInitialization()) {
                this.log.error("Metadata backup file path was invalid, initialization is fatal");
                throw new ComponentInitializationException("Metadata backup file path was invalid", (Exception)((Object)e));
            }
            this.log.error("Metadata backup file path was invalid, continuing without known good backup file");
        }
        super.initMetadataResolver();
    }

    protected void setBackupFile(String backupFilePath) throws ResolverException {
        File backingFile;
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.metadataBackupFile = backingFile = new File(backupFilePath);
    }

    protected void validateBackupFile(File backupFile) throws ResolverException {
        if (!backupFile.exists()) {
            try {
                backupFile.createNewFile();
            }
            catch (IOException e) {
                String msg = "Unable to create backing file " + backupFile.getAbsolutePath();
                this.log.error(msg, (Throwable)e);
                throw new ResolverException(msg, (Exception)e);
            }
        }
        if (backupFile.isDirectory()) {
            throw new ResolverException("Filepath " + backupFile.getAbsolutePath() + " is a directory and may not be used as a backing metadata file");
        }
        if (!backupFile.canRead()) {
            throw new ResolverException("Filepath " + backupFile.getAbsolutePath() + " exists but can not be read by this user");
        }
        if (!backupFile.canWrite()) {
            throw new ResolverException("Filepath " + backupFile.getAbsolutePath() + " exists but can not be written to by this user");
        }
    }

    @Override
    protected byte[] fetchMetadata() throws ResolverException {
        try {
            return super.fetchMetadata();
        }
        catch (ResolverException e) {
            if (this.metadataBackupFile.exists()) {
                this.log.warn("Problem reading metadata from remote source, processing existing backup file: {}", (Object)this.metadataBackupFile.getAbsolutePath());
                try {
                    return Files.toByteArray((File)this.metadataBackupFile);
                }
                catch (IOException ioe) {
                    String errMsg = "Unable to retrieve metadata from backup file " + this.metadataBackupFile.getAbsolutePath();
                    this.log.error(errMsg, (Throwable)ioe);
                    throw new ResolverException(errMsg, (Exception)ioe);
                }
            }
            this.log.error("Unable to read metadata from remote server and backup does not exist");
            throw new ResolverException("Unable to read metadata from remote server and backup does not exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void postProcessMetadata(byte[] metadataBytes, Document metadataDom, XMLObject originalMetadata, XMLObject filteredMetadata) throws ResolverException {
        try {
            this.validateBackupFile(this.metadataBackupFile);
            try (FileOutputStream out = new FileOutputStream(this.metadataBackupFile);){
                out.write(metadataBytes);
                out.flush();
            }
        }
        catch (ResolverException e) {
            this.log.error("Unable to write metadata to backup file: {}", (Object)this.metadataBackupFile.getAbsoluteFile(), (Object)e);
        }
        catch (IOException e) {
            this.log.error("Unable to write metadata to backup file: {}", (Object)this.metadataBackupFile.getAbsoluteFile(), (Object)e);
        }
        finally {
            super.postProcessMetadata(metadataBytes, metadataDom, originalMetadata, filteredMetadata);
        }
    }
}

