/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

// typedef: cluster.stats.ClusterShardMetrics

@JsonpDeserializable
public class ClusterShardMetrics implements PlainJsonSerializable {
    private final double avg;

    private final double max;

    private final double min;

    // ---------------------------------------------------------------------------------------------

    private ClusterShardMetrics(Builder builder) {

        this.avg = ApiTypeHelper.requireNonNull(builder.avg, this, "avg");
        this.max = ApiTypeHelper.requireNonNull(builder.max, this, "max");
        this.min = ApiTypeHelper.requireNonNull(builder.min, this, "min");

    }

    public static ClusterShardMetrics of(Function<Builder, ObjectBuilder<ClusterShardMetrics>> fn) {
        return fn.apply(new Builder()).build();
    }

    /**
     * Required - API name: {@code avg}
     */
    public final double avg() {
        return this.avg;
    }

    /**
     * Required - API name: {@code max}
     */
    public final double max() {
        return this.max;
    }

    /**
     * Required - API name: {@code min}
     */
    public final double min() {
        return this.min;
    }

    /**
     * Serialize this object to JSON.
     */
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {

        generator.writeKey("avg");
        generator.write(this.avg);

        generator.writeKey("max");
        generator.write(this.max);

        generator.writeKey("min");
        generator.write(this.min);

    }

    // ---------------------------------------------------------------------------------------------

    /**
     * Builder for {@link ClusterShardMetrics}.
     */

    public static class Builder extends ObjectBuilderBase implements ObjectBuilder<ClusterShardMetrics> {
        private Double avg;

        private Double max;

        private Double min;

        /**
         * Required - API name: {@code avg}
         */
        public final Builder avg(double value) {
            this.avg = value;
            return this;
        }

        /**
         * Required - API name: {@code max}
         */
        public final Builder max(double value) {
            this.max = value;
            return this;
        }

        /**
         * Required - API name: {@code min}
         */
        public final Builder min(double value) {
            this.min = value;
            return this;
        }

        /**
         * Builds a {@link ClusterShardMetrics}.
         *
         * @throws NullPointerException
         *             if some of the required fields are null.
         */
        public ClusterShardMetrics build() {
            _checkSingleUse();

            return new ClusterShardMetrics(this);
        }
    }

    // ---------------------------------------------------------------------------------------------

    /**
     * Json deserializer for {@link ClusterShardMetrics}
     */
    public static final JsonpDeserializer<ClusterShardMetrics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(
        Builder::new,
        ClusterShardMetrics::setupClusterShardMetricsDeserializer
    );

    protected static void setupClusterShardMetricsDeserializer(ObjectDeserializer<ClusterShardMetrics.Builder> op) {

        op.add(Builder::avg, JsonpDeserializer.doubleDeserializer(), "avg");
        op.add(Builder::max, JsonpDeserializer.doubleDeserializer(), "max");
        op.add(Builder::min, JsonpDeserializer.doubleDeserializer(), "min");

    }

}
