/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.core.RankEvalResponse;
import org.opensearch.client.opensearch.core.rank_eval.RankEvalMetric;
import org.opensearch.client.opensearch.core.rank_eval.RankEvalRequestItem;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class RankEvalRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowNoIndices;
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean ignoreUnavailable;
    private final List<String> index;
    @Nullable
    private final RankEvalMetric metric;
    private final List<RankEvalRequestItem> requests;
    @Nullable
    private final String searchType;
    public static final JsonpDeserializer<RankEvalRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankEvalRequest::setupRankEvalRequestDeserializer);
    public static final Endpoint<RankEvalRequest, RankEvalResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RankEvalRequest, RankEvalResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (!(propsSet |= true)) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_rank_eval");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_rank_eval");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.searchType != null) {
            params.put("search_type", request.searchType);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, RankEvalResponse._DESERIALIZER);

    private RankEvalRequest(Builder builder) {
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.metric = builder.metric;
        this.requests = ApiTypeHelper.unmodifiableRequired(builder.requests, (Object)this, "requests");
        this.searchType = builder.searchType;
    }

    public static RankEvalRequest of(Function<Builder, ObjectBuilder<RankEvalRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final RankEvalMetric metric() {
        return this.metric;
    }

    public final List<RankEvalRequestItem> requests() {
        return this.requests;
    }

    @Nullable
    public final String searchType() {
        return this.searchType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.metric != null) {
            generator.writeKey("metric");
            this.metric.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.requests)) {
            generator.writeKey("requests");
            generator.writeStartArray();
            for (RankEvalRequestItem item0 : this.requests) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public Builder toBuilder() {
        return new Builder().allowNoIndices(this.allowNoIndices).expandWildcards(this.expandWildcards).ignoreUnavailable(this.ignoreUnavailable).index(this.index).metric(this.metric).requests(this.requests).searchType(this.searchType);
    }

    protected static void setupRankEvalRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::metric, RankEvalMetric._DESERIALIZER, "metric");
        op.add(Builder::requests, JsonpDeserializer.arrayDeserializer(RankEvalRequestItem._DESERIALIZER), "requests");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RankEvalRequest> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean ignoreUnavailable;
        private List<String> index;
        @Nullable
        private RankEvalMetric metric;
        private List<RankEvalRequestItem> requests;
        @Nullable
        private String searchType;

        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder metric(@Nullable RankEvalMetric value) {
            this.metric = value;
            return this;
        }

        public final Builder metric(Function<RankEvalMetric.Builder, ObjectBuilder<RankEvalMetric>> fn) {
            return this.metric(fn.apply(new RankEvalMetric.Builder()).build());
        }

        public final Builder requests(List<RankEvalRequestItem> list) {
            this.requests = Builder._listAddAll(this.requests, list);
            return this;
        }

        public final Builder requests(RankEvalRequestItem value, RankEvalRequestItem ... values) {
            this.requests = Builder._listAdd(this.requests, value, values);
            return this;
        }

        public final Builder requests(Function<RankEvalRequestItem.Builder, ObjectBuilder<RankEvalRequestItem>> fn) {
            return this.requests(fn.apply(new RankEvalRequestItem.Builder()).build(), new RankEvalRequestItem[0]);
        }

        public final Builder searchType(@Nullable String value) {
            this.searchType = value;
            return this;
        }

        @Override
        public RankEvalRequest build() {
            this._checkSingleUse();
            return new RankEvalRequest(this);
        }
    }
}

