/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.bulk;

import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.VersionType;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class BulkOperationBase
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final String index;
    @Nullable
    private final String routing;
    @Nullable
    private final Long ifPrimaryTerm;
    @Nullable
    private final Long ifSeqNo;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;

    protected BulkOperationBase(AbstractBuilder<?> builder) {
        this.id = ((AbstractBuilder)builder).id;
        this.index = ((AbstractBuilder)builder).index;
        this.routing = ((AbstractBuilder)builder).routing;
        this.ifPrimaryTerm = ((AbstractBuilder)builder).ifPrimaryTerm;
        this.ifSeqNo = ((AbstractBuilder)builder).ifSeqNo;
        this.version = ((AbstractBuilder)builder).version;
        this.versionType = ((AbstractBuilder)builder).versionType;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Nullable
    public final Long ifSeqNo() {
        return this.ifSeqNo;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("_id");
            generator.write(this.id);
        }
        if (this.index != null) {
            generator.writeKey("_index");
            generator.write(this.index);
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.ifPrimaryTerm != null) {
            generator.writeKey("if_primary_term");
            generator.write(this.ifPrimaryTerm.longValue());
        }
        if (this.ifSeqNo != null) {
            generator.writeKey("if_seq_no");
            generator.write(this.ifSeqNo.longValue());
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (this.versionType != null) {
            generator.writeKey("version_type");
            this.versionType.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupBulkOperationBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(AbstractBuilder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(AbstractBuilder::routing, JsonpDeserializer.stringDeserializer(), "routing");
        op.add(AbstractBuilder::ifPrimaryTerm, JsonpDeserializer.longDeserializer(), "if_primary_term");
        op.add(AbstractBuilder::ifSeqNo, JsonpDeserializer.longDeserializer(), "if_seq_no");
        op.add(AbstractBuilder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(AbstractBuilder::versionType, VersionType._DESERIALIZER, "version_type");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private String id;
        @Nullable
        private String index;
        @Nullable
        private String routing;
        @Nullable
        private Long ifPrimaryTerm;
        @Nullable
        private Long ifSeqNo;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        protected AbstractBuilder() {
        }

        public final BuilderT id(@Nullable String value) {
            this.id = value;
            return this.self();
        }

        public final BuilderT index(@Nullable String value) {
            this.index = value;
            return this.self();
        }

        public final BuilderT routing(@Nullable String value) {
            this.routing = value;
            return this.self();
        }

        public final BuilderT ifPrimaryTerm(@Nullable Long value) {
            this.ifPrimaryTerm = value;
            return this.self();
        }

        public final BuilderT ifSeqNo(@Nullable Long value) {
            this.ifSeqNo = value;
            return this.self();
        }

        public final BuilderT version(@Nullable Long value) {
            this.version = value;
            return this.self();
        }

        public final BuilderT versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

