/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.inject.internal;

import java.lang.reflect.Field;
import javax.inject.Inject;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.util.Filter;
import org.ops4j.pax.exam.util.Injector;
import org.ops4j.pax.swissbox.tracker.ServiceLookup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;

public class ServiceInjector
implements Injector {
    public void injectFields(Object target) {
        for (Class<?> targetClass = target.getClass(); targetClass != Object.class; targetClass = targetClass.getSuperclass()) {
            this.injectDeclaredFields(target, targetClass);
        }
    }

    private void injectDeclaredFields(Object target, Class<?> targetClass) {
        for (Field field : targetClass.getDeclaredFields()) {
            if (field.getAnnotation(Inject.class) == null) continue;
            this.injectField(target, targetClass, field);
        }
    }

    private void injectField(Object target, Class<?> targetClass, Field field) {
        Class<?> type = field.getType();
        String filterString = "";
        String timeoutProp = System.getProperty("pax.exam.service.timeout", "10000");
        long timeout = Integer.parseInt(timeoutProp);
        Filter filter = field.getAnnotation(Filter.class);
        if (filter != null) {
            filterString = filter.value();
            timeout = filter.timeout();
        }
        BundleContext bc = this.getBundleContext(targetClass, timeout);
        BundleContext service = BundleContext.class == type ? bc : ServiceLookup.getService((BundleContext)bc, type, (long)timeout, (String)filterString);
        this.setField(target, field, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setField(Object target, Field field, Object service) {
        block6: {
            try {
                if (field.isAccessible()) {
                    field.set(target, service);
                    break block6;
                }
                field.setAccessible(true);
                try {
                    field.set(target, service);
                }
                finally {
                    field.setAccessible(false);
                }
            }
            catch (IllegalAccessException exc) {
                throw new RuntimeException(exc);
            }
        }
    }

    private BundleContext getBundleContext(Class<?> klass, long timeout) {
        try {
            BundleReference bundleRef = (BundleReference)BundleReference.class.cast(klass.getClassLoader());
            Bundle bundle = bundleRef.getBundle();
            return this.getBundleContext(bundle, timeout);
        }
        catch (ClassCastException exc) {
            throw new TestContainerException("class " + klass.getName() + " is not loaded from an OSGi bundle");
        }
    }

    private BundleContext getBundleContext(Bundle bundle, long timeout) {
        long endTime = System.currentTimeMillis() + timeout;
        BundleContext bc = null;
        while (bc == null) {
            bc = bundle.getBundleContext();
            if (bc != null) continue;
            if (System.currentTimeMillis() >= endTime) {
                throw new TestContainerException("Unable to retrieve bundle context from bundle " + bundle);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return bc;
    }
}

