/*
 * Decompiled with CFR 0.152.
 */
package org.nocrala.tools.texttablefmt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.nocrala.tools.texttablefmt.BorderStyle;
import org.nocrala.tools.texttablefmt.Cell;
import org.nocrala.tools.texttablefmt.CellStyle;
import org.nocrala.tools.texttablefmt.Column;
import org.nocrala.tools.texttablefmt.Row;
import org.nocrala.tools.texttablefmt.ShownBorders;
import org.nocrala.tools.texttablefmt.Table;
import org.nocrala.tools.utils.Filler;
import org.nocrala.tools.utils.TextEncoder;

class TableStyle {
    private static Logger logger = Logger.getLogger(TableStyle.class);
    private ShownBorders shownBorders;
    BorderStyle borderStyle;
    private boolean escapeXml;
    private int leftMargin;
    private String prompt;

    public TableStyle(BorderStyle borderStyle, ShownBorders shownBorders, boolean escapeXml, int leftMargin, String prompt) {
        this.borderStyle = borderStyle;
        this.shownBorders = shownBorders;
        this.escapeXml = escapeXml;
        this.leftMargin = leftMargin;
        this.prompt = prompt;
        if (this.prompt == null) {
            this.prompt = this.leftMargin > 0 ? Filler.getFiller(this.leftMargin) : "";
        }
    }

    private String escapeXmlIfRequired(String txt) {
        if (this.escapeXml) {
            StringBuffer sb = new StringBuffer();
            sb.append(TextEncoder.escapeXml(txt));
            return sb.toString();
        }
        return txt;
    }

    private String escapeXmlIfRequired(String txt1, String txt2) {
        if (this.escapeXml) {
            StringBuffer sb = new StringBuffer();
            sb.append(TextEncoder.escapeXml(txt1));
            sb.append(TextEncoder.escapeXml(txt2));
            return sb.toString();
        }
        return txt1 + txt2;
    }

    String renderTable(Table table) {
        StringBuffer sb = new StringBuffer();
        int totalRows = table.getRows().size();
        Row previousRow = null;
        boolean firstRenderedRow = true;
        for (int i = 0; i < totalRows; ++i) {
            Row r = table.getRows().get(i);
            boolean isFirst = i == 0;
            boolean isSecond = i == 1;
            boolean isIntermediate = i > 1 && i < totalRows - 1;
            boolean isLast = i == totalRows - 1;
            List<String> rr = this.renderRow(r, previousRow, table.getColumns(), isFirst, isSecond, isIntermediate, isLast);
            for (String line : rr) {
                if (firstRenderedRow) {
                    firstRenderedRow = false;
                } else {
                    sb.append("\n");
                }
                sb.append(line);
            }
            previousRow = r;
        }
        return sb.toString();
    }

    String[] renderAsStringArray(Table table) {
        int totalRows = table.getRows().size();
        Row previousRow = null;
        ArrayList<String> allLines = new ArrayList<String>();
        for (int i = 0; i < totalRows; ++i) {
            Row r = table.getRows().get(i);
            boolean isFirst = i == 0;
            boolean isSecond = i == 1;
            boolean isIntermediate = i > 1 && i < totalRows - 1;
            boolean isLast = i == totalRows - 1;
            List<String> rr = this.renderRow(r, previousRow, table.getColumns(), isFirst, isSecond, isIntermediate, isLast);
            for (String line : rr) {
                allLines.add(line);
            }
            previousRow = r;
        }
        String[] result = new String[allLines.size()];
        int i = 0;
        Iterator i$ = allLines.iterator();
        while (i$.hasNext()) {
            String line;
            result[i] = line = (String)i$.next();
            ++i;
        }
        return result;
    }

    void renderRow(Appendable ap, Row r, Row previousRow, List<Column> columns, boolean isFirst, boolean isSecond, boolean isIntermediate, boolean isLast) throws IOException {
        List<String> rr = this.renderRow(r, previousRow, columns, isFirst, isSecond, isIntermediate, isLast);
        boolean firstRenderedRow = isFirst;
        for (String line : rr) {
            if (firstRenderedRow) {
                firstRenderedRow = false;
            } else {
                ap.append("\n");
            }
            ap.append(line);
        }
    }

    private List<String> renderRow(Row r, Row previousRow, List<Column> columns, boolean isFirst, boolean isSecond, boolean isIntermediate, boolean isLast) {
        ArrayList<String> list = new ArrayList<String>();
        if (isFirst) {
            if (this.shownBorders.showTopBorder()) {
                list.add(this.escapeXmlIfRequired(this.prompt, this.shownBorders.renderTopBorder(columns, this.borderStyle, r)));
            }
        } else if (isIntermediate && this.shownBorders.showMiddleSeparator() || isSecond && this.shownBorders.showHeaderSeparator() || isLast && this.shownBorders.showFooterSeparator()) {
            list.add(this.escapeXmlIfRequired(this.prompt, this.shownBorders.renderMiddleSeparator(columns, this.borderStyle, previousRow, r)));
        }
        logger.debug((Object)("+++++++ r.getSize()=" + r.getSize()));
        list.add(this.escapeXmlIfRequired(this.prompt, this.renderContentRow(r, columns)));
        if (isLast && this.shownBorders.showBottomBorder()) {
            list.add(this.escapeXmlIfRequired(this.prompt, this.shownBorders.renderBottomBorder(columns, this.borderStyle, r)));
        }
        return list;
    }

    private String renderContentRow(Row r, List<Column> columns) {
        StringBuffer sb = new StringBuffer();
        if (this.shownBorders.showLeftBorder()) {
            sb.append(this.borderStyle.getLeft());
        }
        int totalColumns = columns.size();
        int j = 0;
        for (Cell cell : r.getCells()) {
            logger.debug((Object)("j=" + j));
            logger.debug((Object)("this.shownBorders.showCenterSeparator()=" + this.shownBorders.showCenterSeparator()));
            logger.debug((Object)("this.shownBorders.showLeftSeparator()=" + this.shownBorders.showLeftSeparator()));
            logger.debug((Object)("this.shownBorders.showRightSeparator()=" + this.shownBorders.showRightSeparator()));
            logger.debug((Object)("this.borderTiles.getCenter()=" + this.borderStyle.getCenter()));
            if (j != 0 && (j > 1 && j < totalColumns - 1 && this.shownBorders.showCenterSeparator() || j == 1 && this.shownBorders.showLeftSeparator() || j == totalColumns - 1 && this.shownBorders.showRightSeparator())) {
                logger.debug((Object)("--- appending '" + this.borderStyle.getCenter() + "' ---"));
                logger.debug((Object)("this.borderTiles.getLeftWidth()=" + this.borderStyle.getLeftWidth()));
                logger.debug((Object)("this.borderTiles.getCenterWidth()=" + this.borderStyle.getCenterWidth()));
                logger.debug((Object)("this.borderTiles.getRightWidth()=" + this.borderStyle.getRightWidth()));
                logger.debug((Object)("this.borderTiles.getHorizontalWidth()=" + this.borderStyle.getHorizontalWidth()));
                sb.append(this.borderStyle.getCenter());
            }
            int sepWidth = this.borderStyle.getCenter().length();
            int width = -sepWidth;
            logger.debug((Object)("* width=" + width));
            for (int pos = j; pos < j + cell.getColSpan(); ++pos) {
                width = width + sepWidth + columns.get(pos).getColumnWidth();
                logger.debug((Object)("** columns.get(" + j + ").getColumnWidth()=" + columns.get(pos).getColumnWidth() + "  width=" + width));
            }
            logger.debug((Object)("*** width=" + width));
            String renderedCell = cell.render(width);
            logger.debug((Object)("content='" + cell.getContent() + "' --> renderedCell=" + renderedCell));
            sb.append(renderedCell);
            j += cell.getColSpan();
        }
        while (j < totalColumns) {
            if (j != 0 && (j > 1 && j < totalColumns - 1 && this.shownBorders.showCenterSeparator() || j == 1 && this.shownBorders.showLeftSeparator() || j == totalColumns - 1 && this.shownBorders.showRightSeparator())) {
                sb.append(this.borderStyle.getCenter());
            }
            Column col = columns.get(j);
            String renderedCell = CellStyle.renderNullCell(col.getColumnWidth());
            sb.append(renderedCell);
            ++j;
        }
        if (this.shownBorders.showRightBorder()) {
            sb.append(this.borderStyle.getRight());
        }
        return sb.toString();
    }
}

