/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.classloader;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.powermock.configuration.GlobalConfiguration;
import org.powermock.core.classloader.MockClassLoader;
import org.powermock.core.classloader.MockClassLoaderConfiguration;
import org.powermock.core.classloader.annotations.PrepareEverythingForTest;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.core.classloader.annotations.PrepareOnlyThisForTest;
import org.powermock.core.classloader.annotations.SuppressStaticInitializationFor;
import org.powermock.core.classloader.annotations.UseClassPathAdjuster;
import org.powermock.core.classloader.javassist.JavassistMockClassLoader;
import org.powermock.core.transformers.MockTransformerChainFactory;
import org.powermock.core.transformers.javassist.JavassistMockTransformerChainFactory;

public enum ByteCodeFramework {
    Javassist{

        @Override
        MockClassLoader createClassloader(MockClassLoaderConfiguration configuration, UseClassPathAdjuster useClassPathAdjuster) {
            return new JavassistMockClassLoader(configuration, useClassPathAdjuster);
        }

        @Override
        MockTransformerChainFactory createTransformerChainFactory() {
            return new JavassistMockTransformerChainFactory();
        }
    };


    public static ByteCodeFramework getByteCodeFrameworkForMethod(Class<?> testClass, Method method) {
        ByteCodeFramework byteCodeFramework = ByteCodeFramework.getByteCodeFramework(method);
        if (byteCodeFramework == null) {
            byteCodeFramework = ByteCodeFramework.getByteCodeFramework(testClass);
        }
        if (byteCodeFramework == null) {
            throw new IllegalArgumentException(String.format("Either method %s or class %s is annotated by PrepareForTest/PrepareEverythingForTest", method.getName(), testClass.getName()));
        }
        return byteCodeFramework;
    }

    public static ByteCodeFramework getByteCodeFrameworkForTestClass(Class<?> testClass) {
        ByteCodeFramework byteCodeFramework = ByteCodeFramework.getByteCodeFramework(testClass);
        if (byteCodeFramework == null) {
            byteCodeFramework = GlobalConfiguration.powerMockConfiguration().getByteCodeFramework();
        }
        return byteCodeFramework;
    }

    private static ByteCodeFramework getByteCodeFramework(AnnotatedElement element) {
        if (element.isAnnotationPresent(PrepareForTest.class)) {
            return element.getAnnotation(PrepareForTest.class).byteCodeFramework();
        }
        if (element.isAnnotationPresent(PrepareOnlyThisForTest.class)) {
            return element.getAnnotation(PrepareOnlyThisForTest.class).byteCodeFramework();
        }
        if (element.isAnnotationPresent(PrepareEverythingForTest.class)) {
            return element.getAnnotation(PrepareEverythingForTest.class).byteCodeFramework();
        }
        if (element.isAnnotationPresent(SuppressStaticInitializationFor.class)) {
            return element.getAnnotation(SuppressStaticInitializationFor.class).byteCodeFramework();
        }
        return null;
    }

    abstract MockClassLoader createClassloader(MockClassLoaderConfiguration var1, UseClassPathAdjuster var2);

    abstract MockTransformerChainFactory createTransformerChainFactory();
}

