/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.transformers.javassist;

import javassist.CtClass;
import javassist.Modifier;
import javassist.NotFoundException;
import org.powermock.core.transformers.TransformStrategy;
import org.powermock.core.transformers.javassist.AbstractJavaAssistMockTransformer;

public class PackagePrivateClassesMockTransformer
extends AbstractJavaAssistMockTransformer {
    public PackagePrivateClassesMockTransformer(TransformStrategy strategy) {
        super(strategy);
    }

    @Override
    public CtClass transform(CtClass clazz) {
        String name = clazz.getName();
        if (this.getStrategy() != TransformStrategy.INST_REDEFINE) {
            PackagePrivateClassesMockTransformer.transform(clazz, name);
        }
        return clazz;
    }

    private static void transform(CtClass clazz, String name) {
        try {
            int modifiers = clazz.getModifiers();
            if (Modifier.isPackage((int)modifiers) && PackagePrivateClassesMockTransformer.isNotSystemClass(name) && (!clazz.isInterface() || clazz.getDeclaringClass() == null)) {
                clazz.setModifiers(Modifier.setPublic((int)modifiers));
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private static boolean isNotSystemClass(String name) {
        return !name.startsWith("java.");
    }
}

