/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v116.webaudio.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v116.webaudio.model.GraphObjectId;
import org.openqa.selenium.json.JsonInput;

public class AudioListener {
    private final GraphObjectId listenerId;
    private final GraphObjectId contextId;

    public AudioListener(GraphObjectId listenerId, GraphObjectId contextId) {
        this.listenerId = Objects.requireNonNull(listenerId, "listenerId is required");
        this.contextId = Objects.requireNonNull(contextId, "contextId is required");
    }

    public GraphObjectId getListenerId() {
        return this.listenerId;
    }

    public GraphObjectId getContextId() {
        return this.contextId;
    }

    private static AudioListener fromJson(JsonInput input) {
        GraphObjectId listenerId = null;
        GraphObjectId contextId = null;
        input.beginObject();
        block8: while (input.hasNext()) {
            switch (input.nextName()) {
                case "listenerId": {
                    listenerId = (GraphObjectId)input.read(GraphObjectId.class);
                    continue block8;
                }
                case "contextId": {
                    contextId = (GraphObjectId)input.read(GraphObjectId.class);
                    continue block8;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AudioListener(listenerId, contextId);
    }
}

