/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi.browsingcontext;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WindowType;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.browsingcontext.BrowsingContextInfo;
import org.openqa.selenium.bidi.browsingcontext.NavigationResult;
import org.openqa.selenium.bidi.browsingcontext.ReadinessState;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeToken;

public class BrowsingContext {
    private final String id;
    private final BiDi bidi;
    private static final String CONTEXT = "context";
    private static final String RELOAD = "browsingContext.reload";
    private static final String HANDLE_USER_PROMPT = "browsingContext.handleUserPrompt";
    protected static final Type LIST_OF_BROWSING_CONTEXT_INFO = new TypeToken<List<BrowsingContextInfo>>(){}.getType();
    private final Function<JsonInput, String> browsingContextIdMapper = jsonInput -> {
        Map result = (Map)jsonInput.read(Map.class);
        return result.getOrDefault(CONTEXT, "").toString();
    };
    private final Function<JsonInput, NavigationResult> navigationInfoMapper = jsonInput -> (NavigationResult)jsonInput.read(NavigationResult.class);
    private final Function<JsonInput, List<BrowsingContextInfo>> browsingContextInfoListMapper = jsonInput -> {
        Map result = (Map)jsonInput.read(Map.class);
        List contexts = result.getOrDefault("contexts", new ArrayList());
        if (contexts.isEmpty()) {
            return new ArrayList();
        }
        Json json = new Json();
        String dtr = json.toJson((Object)contexts);
        return (List)json.toType(dtr, LIST_OF_BROWSING_CONTEXT_INFO);
    };

    public BrowsingContext(WebDriver driver, String id) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        Require.nonNull((String)"Browsing Context id", (Object)id);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)driver).getBiDi();
        this.id = id;
    }

    public BrowsingContext(WebDriver driver, WindowType type) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)driver).getBiDi();
        this.id = this.create(type);
    }

    public BrowsingContext(WebDriver driver, WindowType type, String referenceContextId) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        Require.nonNull((String)"Reference browsing context id", (Object)referenceContextId);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)driver).getBiDi();
        this.id = this.create(type, referenceContextId);
    }

    public String getId() {
        return this.id;
    }

    private String create(WindowType type) {
        return this.bidi.send(new Command<String>("browsingContext.create", (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)type.toString()), this.browsingContextIdMapper));
    }

    private String create(WindowType type, String referenceContext) {
        return this.bidi.send(new Command<String>("browsingContext.create", (Map<String, Object>)ImmutableMap.of((Object)"type", (Object)type.toString(), (Object)"referenceContext", (Object)referenceContext), this.browsingContextIdMapper));
    }

    public NavigationResult navigate(String url) {
        return this.bidi.send(new Command<NavigationResult>("browsingContext.navigate", (Map<String, Object>)ImmutableMap.of((Object)CONTEXT, (Object)this.id, (Object)"url", (Object)url), this.navigationInfoMapper));
    }

    public NavigationResult navigate(String url, ReadinessState readinessState) {
        return this.bidi.send(new Command<NavigationResult>("browsingContext.navigate", (Map<String, Object>)ImmutableMap.of((Object)CONTEXT, (Object)this.id, (Object)"url", (Object)url, (Object)"wait", (Object)readinessState.toString()), this.navigationInfoMapper));
    }

    public List<BrowsingContextInfo> getTree() {
        return this.bidi.send(new Command<List<BrowsingContextInfo>>("browsingContext.getTree", (Map<String, Object>)ImmutableMap.of((Object)"root", (Object)this.id), this.browsingContextInfoListMapper));
    }

    public List<BrowsingContextInfo> getTree(int maxDepth) {
        return this.bidi.send(new Command<List<BrowsingContextInfo>>("browsingContext.getTree", (Map<String, Object>)ImmutableMap.of((Object)"root", (Object)this.id, (Object)"maxDepth", (Object)maxDepth), this.browsingContextInfoListMapper));
    }

    public List<BrowsingContextInfo> getTopLevelContexts() {
        return this.bidi.send(new Command<List<BrowsingContextInfo>>("browsingContext.getTree", new HashMap<String, Object>(), this.browsingContextInfoListMapper));
    }

    public NavigationResult reload() {
        return this.bidi.send(new Command<NavigationResult>(RELOAD, (Map<String, Object>)ImmutableMap.of((Object)CONTEXT, (Object)this.id), this.navigationInfoMapper));
    }

    private NavigationResult reload(boolean ignoreCache) {
        return this.bidi.send(new Command<NavigationResult>(RELOAD, (Map<String, Object>)ImmutableMap.of((Object)CONTEXT, (Object)this.id, (Object)"ignoreCache", (Object)ignoreCache), this.navigationInfoMapper));
    }

    public NavigationResult reload(ReadinessState readinessState) {
        return this.bidi.send(new Command<NavigationResult>(RELOAD, (Map<String, Object>)ImmutableMap.of((Object)CONTEXT, (Object)this.id, (Object)"wait", (Object)readinessState.toString()), this.navigationInfoMapper));
    }

    private NavigationResult reload(boolean ignoreCache, ReadinessState readinessState) {
        return this.bidi.send(new Command<NavigationResult>(RELOAD, (Map<String, Object>)ImmutableMap.of((Object)CONTEXT, (Object)this.id, (Object)"ignoreCache", (Object)ignoreCache, (Object)"wait", (Object)readinessState.toString()), this.navigationInfoMapper));
    }

    public void handleUserPrompt() {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, (Map<String, Object>)ImmutableMap.of((Object)CONTEXT, (Object)this.id)));
    }

    public void handleUserPrompt(boolean accept) {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, (Map<String, Object>)ImmutableMap.of((Object)CONTEXT, (Object)this.id, (Object)"accept", (Object)accept)));
    }

    public void handleUserPrompt(String userText) {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, (Map<String, Object>)ImmutableMap.of((Object)CONTEXT, (Object)this.id, (Object)"userText", (Object)userText)));
    }

    public void handleUserPrompt(boolean accept, String userText) {
        this.bidi.send(new Command(HANDLE_USER_PROMPT, (Map<String, Object>)ImmutableMap.of((Object)CONTEXT, (Object)this.id, (Object)"accept", (Object)accept, (Object)"userText", (Object)userText)));
    }

    public String captureScreenshot() {
        return this.bidi.send(new Command<String>("browsingContext.captureScreenshot", (Map<String, Object>)ImmutableMap.of((Object)CONTEXT, (Object)this.id), jsonInput -> {
            Map result = (Map)jsonInput.read(Map.class);
            return (String)result.get("data");
        }));
    }

    public void close() {
        this.bidi.send(new Command("browsingContext.close", (Map<String, Object>)ImmutableMap.of((Object)CONTEXT, (Object)this.id)));
    }
}

