/*
 * Decompiled with CFR 0.152.
 */
package org.simdjson;

import org.simdjson.JsonParsingException;

class ExponentParser {
    private final ExponentParsingResult result = new ExponentParsingResult();

    ExponentParser() {
    }

    static boolean isExponentIndicator(byte b) {
        return 101 == b || 69 == b;
    }

    ExponentParsingResult parse(byte[] buffer, int currentIdx, long exponent) {
        boolean negative;
        boolean bl = negative = 45 == buffer[currentIdx];
        if (negative || 43 == buffer[currentIdx]) {
            ++currentIdx;
        }
        int exponentStartIdx = currentIdx;
        long parsedExponent = 0L;
        byte digit = ExponentParser.convertCharacterToDigit(buffer[currentIdx]);
        while (digit >= 0 && digit <= 9) {
            parsedExponent = 10L * parsedExponent + (long)digit;
            digit = ExponentParser.convertCharacterToDigit(buffer[++currentIdx]);
        }
        if (exponentStartIdx == currentIdx) {
            throw new JsonParsingException("Invalid number. Exponent indicator has to be followed by a digit.");
        }
        int maxDigitCountLongCanAccommodate = 18;
        if (currentIdx > exponentStartIdx + maxDigitCountLongCanAccommodate) {
            while (buffer[exponentStartIdx] == 48) {
                ++exponentStartIdx;
            }
            if (currentIdx > exponentStartIdx + maxDigitCountLongCanAccommodate) {
                parsedExponent = 999999999999999999L;
            }
        }
        return this.result.of(exponent += negative ? -parsedExponent : parsedExponent, currentIdx);
    }

    private static byte convertCharacterToDigit(byte b) {
        return (byte)(b - 48);
    }

    static class ExponentParsingResult {
        private long exponent;
        private int currentIdx;

        ExponentParsingResult() {
        }

        ExponentParsingResult of(long exponent, int currentIdx) {
            this.exponent = exponent;
            this.currentIdx = currentIdx;
            return this;
        }

        long exponent() {
            return this.exponent;
        }

        int currentIdx() {
            return this.currentIdx;
        }
    }
}

