/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.license.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import org.apache.commons.io.IOUtils;
import org.smartboot.license.client.LicenseEntity;
import org.smartboot.license.client.LicenseException;
import org.smartboot.license.client.Md5;
import org.smartboot.license.client.RuntimeExpireStrategy;

public class License {
    public static final RuntimeExpireStrategy EXPIRE_STRATEGY_IGNORE = new RuntimeExpireStrategy(){

        @Override
        public void expire() {
            System.err.println("invalid license");
        }
    };
    public static final RuntimeExpireStrategy EXPIRE_STRATEGY_THROWS = new RuntimeExpireStrategy(){

        @Override
        public void expire() {
            throw new LicenseException("invalid license");
        }
    };
    private static final String KEY_ALGORITHM = "RSA";
    private RuntimeExpireStrategy expireStrategy = EXPIRE_STRATEGY_THROWS;

    private byte[] decryptByPublicKey(byte[] byArray, byte[] byArray2) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, publicKey);
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new LicenseException("decrypt exception", exception);
        }
    }

    public LicenseEntity loadLicense(File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            LicenseEntity licenseEntity = this.loadLicense(fileInputStream);
            return licenseEntity;
        }
        catch (Exception exception) {
            throw new LicenseException("load license exception", exception);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                    fileInputStream = null;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public LicenseEntity loadLicense(InputStream inputStream, byte[] byArray) {
        try {
            LicenseEntity licenseEntity = this.loadLicense(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(licenseEntity.getData());
            while (byteArrayInputStream.available() > 0) {
                byte[] byArray2 = new byte[byteArrayInputStream.read()];
                byteArrayInputStream.read(byArray2);
                byteArrayOutputStream.write(this.decryptByPublicKey(byArray2, byArray));
            }
            licenseEntity.setData(byteArrayOutputStream.toByteArray());
            return licenseEntity;
        }
        catch (LicenseException licenseException) {
            throw licenseException;
        }
        catch (Exception exception) {
            throw new LicenseException("load license exception", exception);
        }
    }

    public LicenseEntity loadLicense(InputStream inputStream) {
        try {
            LicenseEntity licenseEntity = this.decode(inputStream);
            this.monitorExpireThread(licenseEntity);
            return licenseEntity;
        }
        catch (LicenseException licenseException) {
            throw licenseException;
        }
        catch (Exception exception) {
            throw new LicenseException("load license exception", exception);
        }
    }

    private void monitorExpireThread(LicenseEntity licenseEntity) {
        Thread thread = new Thread(() -> {
            try {
                Thread.sleep(licenseEntity.getExpireTime() - System.currentTimeMillis());
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.expireStrategy.expire();
        }, "licenseMonitor");
        thread.setDaemon(true);
        thread.start();
    }

    private LicenseEntity decode(InputStream inputStream) throws IOException, ClassNotFoundException {
        byte[] byArray;
        byte[] byArray2 = Base64.getDecoder().decode(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        byte[] byArray3 = new byte[LicenseEntity.MAGIC_NUM.length];
        byteArrayInputStream.read(byArray3);
        this.checkBytes(byArray3, LicenseEntity.MAGIC_NUM);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        LicenseEntity licenseEntity = (LicenseEntity)objectInputStream.readObject();
        this.checkSplitBytes(objectInputStream, licenseEntity);
        long l = objectInputStream.readLong();
        if (l > System.currentTimeMillis()) {
            throw new LicenseException("invalid license");
        }
        long l2 = objectInputStream.readLong();
        if (l2 != licenseEntity.getExpireTime()) {
            throw new LicenseException("invalid license");
        }
        if (l2 < System.currentTimeMillis()) {
            throw new LicenseException("license expire");
        }
        this.checkSplitBytes(objectInputStream, licenseEntity);
        byte[] byArray4 = new byte[objectInputStream.read()];
        objectInputStream.read(byArray4);
        this.checkBytes(byArray4, licenseEntity.getPublicKeys());
        this.checkSplitBytes(objectInputStream, licenseEntity);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while ((n = objectInputStream.read()) != 0) {
            byArray = new byte[n];
            objectInputStream.read(byArray);
            byte[] byArray5 = this.decryptByPublicKey(byArray, licenseEntity.getPublicKeys());
            byteArrayOutputStream.write(byArray5);
            this.checkSplitBytes(objectInputStream, licenseEntity);
            if (objectInputStream.readLong() == l2 % (long)byArray5.length) continue;
            throw new LicenseException("invalid license");
        }
        byArray = byteArrayOutputStream.toByteArray();
        if (!Md5.md5(byArray).equals(licenseEntity.getMd5())) {
            throw new LicenseException("invalid license");
        }
        licenseEntity.setData(byArray);
        return licenseEntity;
    }

    private void checkSplitBytes(InputStream inputStream, LicenseEntity licenseEntity) throws IOException {
        byte[] byArray = new byte[licenseEntity.getSplitFlag().length];
        inputStream.read(byArray);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == licenseEntity.getSplitFlag()[i]) continue;
            throw new LicenseException("invalid license");
        }
    }

    private void checkBytes(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            throw new LicenseException("invalid license");
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            throw new LicenseException("invalid license");
        }
    }

    public void setExpireStrategy(RuntimeExpireStrategy runtimeExpireStrategy) {
        this.expireStrategy = runtimeExpireStrategy;
    }
}

