/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.maven;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.toolchain.ToolchainManager;
import org.sonarsource.scanner.lib.EnvironmentConfig;
import org.sonarsource.scanner.lib.ScannerEngineBootstrapper;
import org.sonarsource.scanner.maven.bootstrap.MavenCompilerResolver;
import org.sonarsource.scanner.maven.bootstrap.MavenProjectConverter;
import org.sonarsource.scanner.maven.bootstrap.PropertyDecryptor;
import org.sonarsource.scanner.maven.bootstrap.ScannerBootstrapper;
import org.sonarsource.scanner.maven.bootstrap.ScannerBootstrapperFactory;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

@Mojo(name="sonar", requiresDependencyResolution=ResolutionScope.TEST, aggregator=true)
public class SonarQubeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(alias="sonar.skip", property="sonar.skip", defaultValue="false")
    private boolean skip;
    @Component
    private LifecycleExecutor lifecycleExecutor;
    @Component(hint="mng-4384")
    private SecDispatcher securityDispatcher;
    @Component
    private RuntimeInformation runtimeInformation;
    @Parameter(defaultValue="${mojoExecution}", required=true, readonly=true)
    private MojoExecution mojoExecution;
    @Component
    private ToolchainManager toolchainManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.shouldDelayExecution()) {
            this.getLog().info((CharSequence)"Delaying SonarQube Scanner to the end of multi-module project");
            return;
        }
        this.warnAboutUnspecifiedSonarPluginVersion();
        Map envProps = EnvironmentConfig.load(System.getenv());
        MavenCompilerResolver mavenCompilerResolver = new MavenCompilerResolver(this.session, this.lifecycleExecutor, this.getLog(), this.toolchainManager);
        MavenProjectConverter mavenProjectConverter = new MavenProjectConverter(this.getLog(), mavenCompilerResolver, envProps);
        PropertyDecryptor propertyDecryptor = new PropertyDecryptor(this.getLog(), this.securityDispatcher);
        ScannerBootstrapperFactory bootstrapperFactory = new ScannerBootstrapperFactory(this.getLog(), this.runtimeInformation, this.mojoExecution, this.session, envProps, propertyDecryptor);
        if (this.isSkip(bootstrapperFactory.createGlobalProperties())) {
            return;
        }
        ScannerEngineBootstrapper bootstrapper = bootstrapperFactory.create();
        boolean success = new ScannerBootstrapper(this.getLog(), this.session, bootstrapper, mavenProjectConverter, propertyDecryptor).execute();
        if (!success) {
            throw new MojoFailureException("Analysis failed");
        }
    }

    private void warnAboutUnspecifiedSonarPluginVersion() {
        boolean requiredArgumentsAreNotNull;
        String effectivePluginVersion = this.mojoExecution.getVersion();
        String groupId = this.mojoExecution.getGroupId();
        String artifactId = this.mojoExecution.getArtifactId();
        Plugin plugin = this.mojoExecution.getPlugin();
        MavenProject project = this.session.getTopLevelProject();
        List goals = this.session.getGoals();
        boolean bl = requiredArgumentsAreNotNull = !Arrays.asList(effectivePluginVersion, groupId, artifactId, plugin, project, goals).contains(null);
        if (requiredArgumentsAreNotNull) {
            String invalidPluginVersion = null;
            String configuredPluginVersion = plugin.getVersion();
            if ("LATEST".equals(configuredPluginVersion) || "RELEASE".equals(configuredPluginVersion)) {
                invalidPluginVersion = configuredPluginVersion;
            } else if (!SonarQubeMojo.isPluginVersionDefinedInTheProject(project, groupId, artifactId) && SonarQubeMojo.isVersionMissingFromSonarGoal(goals, groupId, artifactId)) {
                invalidPluginVersion = "an unspecified version";
            }
            if (invalidPluginVersion != null) {
                this.getLog().warn((CharSequence)String.format("Using %s instead of an explicit plugin version may introduce breaking analysis changes at an unwanted time. It is highly recommended to use an explicit version, e.g. '%s:%s:%s'.", invalidPluginVersion, groupId, artifactId, effectivePluginVersion));
            }
        }
    }

    @VisibleForTesting
    static boolean isPluginVersionDefinedInTheProject(MavenProject project, String groupId, String artifactId) {
        Stream pluginStream = project.getBuildPlugins().stream();
        PluginManagement pluginManagement = project.getPluginManagement();
        pluginStream = pluginManagement != null ? Stream.concat(pluginStream, pluginManagement.getPlugins().stream()) : pluginStream;
        return pluginStream.anyMatch(plugin -> (plugin.getGroupId() == null || groupId.equals(plugin.getGroupId())) && artifactId.equals(plugin.getArtifactId()) && plugin.getVersion() != null && !plugin.getVersion().isBlank());
    }

    private static boolean isVersionMissingFromSonarGoal(List<String> goals, String groupId, String artifactId) {
        List<String> sonarGoalsWithoutVersion = Arrays.asList("sonar:sonar", groupId + ":" + artifactId + ":sonar");
        return goals.stream().anyMatch(sonarGoalsWithoutVersion::contains);
    }

    private boolean shouldDelayExecution() {
        return !this.isDetachedGoal() && !this.isLastProjectInReactor();
    }

    private boolean isDetachedGoal() {
        return "default-cli".equals(this.mojoExecution.getExecutionId());
    }

    private boolean isLastProjectInReactor() {
        MavenProject lastProject;
        List sortedProjects = this.session.getProjectDependencyGraph().getSortedProjects();
        MavenProject mavenProject = lastProject = sortedProjects.isEmpty() ? this.session.getCurrentProject() : (MavenProject)sortedProjects.get(sortedProjects.size() - 1);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Current project: '" + this.session.getCurrentProject().getName() + "', Last project to execute based on dependency graph: '" + lastProject.getName() + "'"));
        }
        return this.session.getCurrentProject().equals((Object)lastProject);
    }

    private boolean isSkip(Map<String, String> properties) {
        if (this.skip) {
            this.getLog().info((CharSequence)"sonar.skip = true: Skipping analysis");
            return true;
        }
        if ("true".equalsIgnoreCase(properties.get("sonar.scanner.skip"))) {
            this.getLog().info((CharSequence)"SonarQube Scanner analysis skipped");
            return true;
        }
        return false;
    }

    MavenSession getSession() {
        return this.session;
    }

    MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }
}

