/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.rule.Rule;
import org.sonar.api.batch.rule.Rules;
import org.sonar.api.batch.rule.internal.DefaultRule;
import org.sonar.api.batch.rule.internal.NewRule;
import org.sonar.api.rule.RuleKey;

@Immutable
class DefaultRules
implements Rules {
    private final Map<String, List<Rule>> rulesByRepository;
    private final Map<String, Map<String, List<Rule>>> rulesByRepositoryAndInternalKey;
    private final Map<RuleKey, Rule> rulesByRuleKey;

    DefaultRules(Collection<NewRule> newRules) {
        HashMap<String, List> rulesByRepositoryBuilder = new HashMap<String, List>();
        HashMap<String, Map<String, List<Rule>>> rulesByRepositoryAndInternalKeyBuilder = new HashMap<String, Map<String, List<Rule>>>();
        HashMap<RuleKey, DefaultRule> rulesByRuleKeyBuilder = new HashMap<RuleKey, DefaultRule>();
        for (NewRule newRule : newRules) {
            DefaultRule r = new DefaultRule(newRule);
            rulesByRuleKeyBuilder.put(r.key(), r);
            rulesByRepositoryBuilder.computeIfAbsent(r.key().repository(), x -> new ArrayList()).add(r);
            DefaultRules.addToTable(rulesByRepositoryAndInternalKeyBuilder, r);
        }
        this.rulesByRuleKey = Collections.unmodifiableMap(rulesByRuleKeyBuilder);
        this.rulesByRepository = Collections.unmodifiableMap(rulesByRepositoryBuilder);
        this.rulesByRepositoryAndInternalKey = Collections.unmodifiableMap(rulesByRepositoryAndInternalKeyBuilder);
    }

    private static void addToTable(Map<String, Map<String, List<Rule>>> rulesByRepositoryAndInternalKeyBuilder, DefaultRule r) {
        if (r.internalKey() == null) {
            return;
        }
        rulesByRepositoryAndInternalKeyBuilder.computeIfAbsent(r.key().repository(), x -> new HashMap()).computeIfAbsent(r.internalKey(), x -> new ArrayList()).add(r);
    }

    public Rule find(RuleKey ruleKey) {
        return this.rulesByRuleKey.get(ruleKey);
    }

    public Collection<Rule> findAll() {
        return this.rulesByRepository.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Collection<Rule> findByRepository(String repository) {
        return this.rulesByRepository.getOrDefault(repository, Collections.emptyList());
    }

    public Collection<Rule> findByInternalKey(String repository, String internalKey) {
        return this.rulesByRepositoryAndInternalKey.getOrDefault(repository, Collections.emptyMap()).getOrDefault(internalKey, Collections.emptyList());
    }
}

