/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.rule.internal;

import java.util.Collection;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.debt.DebtRemediationFunction;
import org.sonar.api.batch.rule.Rule;
import org.sonar.api.batch.rule.RuleParam;
import org.sonar.api.batch.rule.internal.DefaultRuleParam;
import org.sonar.api.batch.rule.internal.NewRule;
import org.sonar.api.batch.rule.internal.NewRuleParam;
import org.sonar.api.internal.google.common.collect.ImmutableMap;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.RuleStatus;

@Immutable
public class DefaultRule
implements Rule {
    private final RuleKey key;
    private final Integer id;
    private final String name;
    private final String severity;
    private final String type;
    private final String description;
    private final String internalKey;
    private final RuleStatus status;
    private final Map<String, RuleParam> params;

    DefaultRule(NewRule newRule) {
        this.key = newRule.key;
        this.id = newRule.id;
        this.name = newRule.name;
        this.severity = newRule.severity;
        this.type = newRule.type;
        this.description = newRule.description;
        this.internalKey = newRule.internalKey;
        this.status = newRule.status;
        ImmutableMap.Builder<String, DefaultRuleParam> builder = ImmutableMap.builder();
        for (NewRuleParam newRuleParam : newRule.params.values()) {
            builder.put(newRuleParam.key, new DefaultRuleParam(newRuleParam));
        }
        this.params = builder.build();
    }

    @Override
    public RuleKey key() {
        return this.key;
    }

    @CheckForNull
    public Integer id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String severity() {
        return this.severity;
    }

    @CheckForNull
    public String type() {
        return this.type;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String internalKey() {
        return this.internalKey;
    }

    @Override
    public RuleStatus status() {
        return this.status;
    }

    @Override
    public String debtSubCharacteristic() {
        throw new UnsupportedOperationException("Debt characteristic is not available by analyzer since version 5.2 (data computation moved to server)");
    }

    @Override
    public DebtRemediationFunction debtRemediationFunction() {
        throw new UnsupportedOperationException("Debt remediation function is not available by analyzer since version 5.2 (data computation moved to server)");
    }

    @Override
    public RuleParam param(String paramKey) {
        return this.params.get(paramKey);
    }

    @Override
    public Collection<RuleParam> params() {
        return this.params.values();
    }
}

