/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.tool;

import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import org.springaicommunity.mcp.context.McpAsyncRequestContext;
import org.springaicommunity.mcp.method.tool.AbstractAsyncMcpToolMethodCallback;
import org.springaicommunity.mcp.method.tool.ReturnMode;
import reactor.core.publisher.Mono;

public final class AsyncStatelessMcpToolMethodCallback
extends AbstractAsyncMcpToolMethodCallback<McpTransportContext, McpAsyncRequestContext>
implements BiFunction<McpTransportContext, McpSchema.CallToolRequest, Mono<McpSchema.CallToolResult>> {
    public AsyncStatelessMcpToolMethodCallback(ReturnMode returnMode, Method toolMethod, Object toolObject) {
        super(returnMode, toolMethod, toolObject, Exception.class);
    }

    public AsyncStatelessMcpToolMethodCallback(ReturnMode returnMode, Method toolMethod, Object toolObject, Class<? extends Throwable> toolCallExceptionClass) {
        super(returnMode, toolMethod, toolObject, toolCallExceptionClass);
    }

    @Override
    protected boolean isExchangeOrContextType(Class<?> paramType) {
        return McpTransportContext.class.isAssignableFrom(paramType) || McpAsyncRequestContext.class.isAssignableFrom(paramType);
    }

    @Override
    protected McpAsyncRequestContext createRequestContext(McpTransportContext exchange, McpSchema.CallToolRequest request) {
        throw new UnsupportedOperationException("Stateless tool methods do not support McpAsyncRequestContext parameter.");
    }

    @Override
    public Mono<McpSchema.CallToolResult> apply(McpTransportContext mcpTransportContext, McpSchema.CallToolRequest request) {
        return this.validateRequest(request).then(Mono.defer(() -> {
            try {
                Object[] args = this.buildMethodArguments(mcpTransportContext, request.arguments(), request);
                Object result = this.callMethod(args);
                return this.convertToCallToolResult(result);
            }
            catch (Exception e) {
                if (this.toolCallExceptionClass.isInstance(e)) {
                    return this.createAsyncErrorResult(e);
                }
                return Mono.error((Throwable)e);
            }
        }));
    }
}

