/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.auto.factories;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.StringJoiner;
import org.springblade.core.auto.common.MultiSetMap;

class FactoriesFiles {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;

    FactoriesFiles() {
    }

    static void writeFactoriesFile(MultiSetMap<String, String> factories, OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, UTF_8));
        Set<String> keySet = factories.keySet();
        for (String key : keySet) {
            Set<String> values = factories.get(key);
            if (values == null || values.isEmpty()) continue;
            writer.write(key);
            writer.write("=\\\n  ");
            StringJoiner joiner = new StringJoiner(",\\\n  ");
            for (String value : values) {
                joiner.add(value);
            }
            writer.write(joiner.toString());
            writer.newLine();
        }
        writer.flush();
        output.close();
    }

    static void writeDevToolsFile(String projectName, OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, UTF_8));
        String format = "restart.include.%s=/%s[\\\\w-]+\\.jar";
        writer.write(String.format(format, projectName, projectName));
        writer.flush();
        output.close();
    }
}

