/*
 * Decompiled with CFR 0.152.
 */
package org.springblade.core.auto.service;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.springblade.core.auto.common.AbstractBladeProcessor;
import org.springblade.core.auto.common.MultiSetMap;
import org.springblade.core.auto.common.Sets;
import org.springblade.core.auto.common.TypeHelper;
import org.springblade.core.auto.service.AutoService;
import org.springblade.core.auto.service.ServicesFiles;

@SupportedOptions(value={"debug"})
public class AutoServiceProcessor
extends AbstractBladeProcessor {
    private final MultiSetMap<String, String> providers = new MultiSetMap();
    private TypeHelper typeHelper;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.typeHelper = new TypeHelper(env);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Sets.ofImmutableSet(AutoService.class.getName());
    }

    @Override
    protected boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateConfigFiles();
        } else {
            this.processAnnotations(annotations, roundEnv);
        }
        return true;
    }

    private void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(AutoService.class);
        this.log(annotations.toString());
        this.log(elements.toString());
        for (Element element : elements) {
            TypeElement providerImplementer = (TypeElement)element;
            AnnotationMirror annotationMirror = this.getAnnotationMirror(element, AutoService.class);
            if (annotationMirror == null) continue;
            Set<TypeMirror> typeMirrors = this.getValueFieldOfClasses(annotationMirror);
            if (typeMirrors.isEmpty()) {
                this.error("No service interfaces provided for element!", element, annotationMirror);
                continue;
            }
            for (TypeMirror typeMirror : typeMirrors) {
                String providerInterfaceName = this.typeHelper.getType(typeMirror);
                Name providerImplementerName = providerImplementer.getQualifiedName();
                this.log("provider interface: " + providerInterfaceName);
                this.log("provider implementer: " + providerImplementerName);
                if (this.checkImplementer(providerImplementer, typeMirror)) {
                    this.providers.put(providerInterfaceName, this.typeHelper.getType(providerImplementer));
                    continue;
                }
                String message = "ServiceProviders must implement their service provider interface. " + providerImplementerName + " does not implement " + providerInterfaceName;
                this.error(message, element, annotationMirror);
            }
        }
    }

    private void generateConfigFiles() {
        Filer filer = this.processingEnv.getFiler();
        for (String providerInterface : this.providers.keySet()) {
            String resourceFile = "META-INF/services/" + providerInterface;
            this.log("Working on resource file: " + resourceFile);
            try {
                TreeSet<String> allServices = new TreeSet<String>();
                try {
                    FileObject existingFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", resourceFile);
                    this.log("Looking for existing resource file at " + existingFile.toUri());
                    Set<String> oldServices = ServicesFiles.readServiceFile(existingFile.openInputStream());
                    this.log("Existing service entries: " + oldServices);
                    allServices.addAll(oldServices);
                }
                catch (IOException e) {
                    this.log("Resource file did not already exist.");
                }
                HashSet<String> newServices = new HashSet<String>(this.providers.get(providerInterface));
                if (allServices.containsAll(newServices)) {
                    this.log("No new service entries being added.");
                    return;
                }
                allServices.addAll(newServices);
                this.log("New service file contents: " + allServices);
                FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceFile, new Element[0]);
                OutputStream out = fileObject.openOutputStream();
                ServicesFiles.writeServiceFile(allServices, out);
                out.close();
                this.log("Wrote to: " + fileObject.toUri());
            }
            catch (IOException e) {
                this.fatalError("Unable to create " + resourceFile + ", " + e);
                return;
            }
        }
    }

    private boolean checkImplementer(TypeElement providerImplementer, TypeMirror providerType) {
        Types types = this.processingEnv.getTypeUtils();
        return types.isSubtype(providerImplementer.asType(), providerType);
    }

    private Set<TypeMirror> getValueFieldOfClasses(AnnotationMirror annotationMirror) {
        return this.getAnnotationValue(annotationMirror, "value").accept(new SimpleAnnotationValueVisitor8<Set<TypeMirror>, Void>(){

            @Override
            public Set<TypeMirror> visitType(TypeMirror typeMirror, Void v) {
                HashSet<TypeMirror> declaredTypeSet = new HashSet<TypeMirror>(1);
                declaredTypeSet.add(typeMirror);
                return Collections.unmodifiableSet(declaredTypeSet);
            }

            @Override
            public Set<TypeMirror> visitArray(List<? extends AnnotationValue> values, Void v) {
                return values.stream().flatMap(value -> value.accept(this, null).stream()).collect(Collectors.toSet());
            }
        }, null);
    }

    public AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror, String elementName) {
        Objects.requireNonNull(annotationMirror);
        Objects.requireNonNull(elementName);
        for (Map.Entry<ExecutableElement, AnnotationValue> entry : this.getAnnotationValuesWithDefaults(annotationMirror).entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(elementName)) continue;
            return entry.getValue();
        }
        String name = this.typeHelper.getType(annotationMirror);
        throw new IllegalArgumentException(String.format("@%s does not define an element %s()", name, elementName));
    }

    public Map<ExecutableElement, AnnotationValue> getAnnotationValuesWithDefaults(AnnotationMirror annotation) {
        HashMap<ExecutableElement, AnnotationValue> values = new HashMap<ExecutableElement, AnnotationValue>(32);
        Map<? extends ExecutableElement, ? extends AnnotationValue> declaredValues = annotation.getElementValues();
        for (ExecutableElement method : ElementFilter.methodsIn(annotation.getAnnotationType().asElement().getEnclosedElements())) {
            if (declaredValues.containsKey(method)) {
                values.put(method, declaredValues.get(method));
                continue;
            }
            if (method.getDefaultValue() != null) {
                values.put(method, method.getDefaultValue());
                continue;
            }
            String name = this.typeHelper.getType(method);
            throw new IllegalStateException("Unset annotation value without default should never happen: " + name + '.' + method.getSimpleName() + "()");
        }
        return Collections.unmodifiableMap(values);
    }

    public AnnotationMirror getAnnotationMirror(Element element, Class<? extends Annotation> annotationClass) {
        String annotationClassName = annotationClass.getCanonicalName();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String name = this.typeHelper.getType(annotationMirror);
            if (!name.contentEquals(annotationClassName)) continue;
            return annotationMirror;
        }
        return null;
    }
}

